"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createVegaFn = void 0;
var _lodash = require("lodash");
var _i18n = require("@kbn/i18n");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
const createVegaFn = dependencies => ({
  name: 'vega',
  type: 'render',
  inputTypes: ['kibana_context', 'null'],
  help: _i18n.i18n.translate('visTypeVega.function.help', {
    defaultMessage: 'Vega visualization'
  }),
  args: {
    spec: {
      types: ['string'],
      default: '',
      help: ''
    }
  },
  async fn(input, args, context) {
    const {
      createVegaRequestHandler
    } = await Promise.resolve().then(() => _interopRequireWildcard(require('./async_services')));
    const vegaRequestHandler = createVegaRequestHandler(dependencies, context);
    const response = await vegaRequestHandler({
      timeRange: (0, _lodash.get)(input, 'timeRange'),
      query: (0, _lodash.get)(input, 'query'),
      filters: (0, _lodash.get)(input, 'filters'),
      visParams: {
        spec: args.spec
      },
      searchSessionId: context.getSearchSessionId(),
      executionContext: context.getExecutionContext()
    });
    return {
      type: 'render',
      as: 'vega_vis',
      value: {
        visData: response,
        visType: 'vega',
        visConfig: {
          spec: args.spec
        }
      }
    };
  }
});
exports.createVegaFn = createVegaFn;