"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createFormulaColumnWithoutMeta = exports.createFormulaColumn = exports.convertOtherAggsToFormulaColumn = exports.convertMathToFormulaColumn = void 0;
var _uuid = require("uuid");
var _metrics = require("../metrics");
var _column = require("./column");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const convertToFormulaParams = formula => ({
  formula
});
const createFormulaColumn = (formula, {
  series,
  metric
}) => {
  const params = convertToFormulaParams(formula);
  return {
    operationType: 'formula',
    references: [],
    ...(0, _column.createColumn)(series, metric, undefined, {
      isAssignTimeScale: false
    }),
    params: {
      ...params,
      ...(0, _column.getFormat)(series)
    }
  };
};
exports.createFormulaColumn = createFormulaColumn;
const createFormulaColumnWithoutMeta = formula => {
  const params = convertToFormulaParams(formula);
  return {
    columnId: (0, _uuid.v4)(),
    operationType: 'formula',
    references: [],
    dataType: 'string',
    isSplit: false,
    isBucketed: false,
    params: {
      ...params
    }
  };
};
exports.createFormulaColumnWithoutMeta = createFormulaColumnWithoutMeta;
const convertFormulaScriptForPercentileAggs = (mathScript, variables, metric, allAggMetrics, additionalArgs) => {
  variables.forEach(variable => {
    var _variable$field$split, _variable$field, _mathScript;
    const [_, meta] = (_variable$field$split = variable === null || variable === void 0 ? void 0 : (_variable$field = variable.field) === null || _variable$field === void 0 ? void 0 : _variable$field.split('[')) !== null && _variable$field$split !== void 0 ? _variable$field$split : [];
    const metaValue = Number(meta === null || meta === void 0 ? void 0 : meta.replace(']', ''));
    if (!metaValue) {
      return;
    }
    const script = (0, _metrics.getFormulaEquivalent)(metric, allAggMetrics, {
      metaValue,
      ...additionalArgs
    });
    if (!script) {
      return;
    }
    mathScript = (_mathScript = mathScript) === null || _mathScript === void 0 ? void 0 : _mathScript.replace(`params.${variable.name}`, script);
  });
  return mathScript;
};
const convertFormulaScriptForAggs = (mathScript, variables, metric, allAggMetrics, additionalArgs) => {
  const script = (0, _metrics.getFormulaEquivalent)(metric, allAggMetrics, {
    ...additionalArgs
  });
  if (!script) {
    return null;
  }
  const variable = variables.find(v => v.field === metric.id);
  return mathScript === null || mathScript === void 0 ? void 0 : mathScript.replaceAll(`params.${variable === null || variable === void 0 ? void 0 : variable.name}`, script);
};
const convertMathToFormulaColumn = ({
  series,
  metrics,
  dataView
}, reducedTimeRange) => {
  // find the metric idx that has math expression
  const metric = metrics.find(({
    type
  }) => type === 'math');
  if (!metric) {
    return null;
  }
  const {
    variables
  } = metric;
  let script = metrics[metrics.length - 1].script;
  if (!script || !variables || !variables.length) {
    return null;
  }
  const metricsWithoutMath = metrics.filter(({
    type
  }) => type !== 'math');

  // create the script
  for (const notMathMetric of metricsWithoutMath) {
    // We can only support top_hit with size 1
    if (notMathMetric.type === 'top_hit' && notMathMetric !== null && notMathMetric !== void 0 && notMathMetric.size && Number(notMathMetric === null || notMathMetric === void 0 ? void 0 : notMathMetric.size) !== 1 || (notMathMetric === null || notMathMetric === void 0 ? void 0 : notMathMetric.order) === 'asc') {
      return null;
    }

    // should treat percentiles differently
    if (notMathMetric.type === 'percentile' || notMathMetric.type === 'percentile_rank') {
      script = convertFormulaScriptForPercentileAggs(script, variables, notMathMetric, metrics, {
        reducedTimeRange,
        timeShift: series.offset_time
      });
    } else {
      script = convertFormulaScriptForAggs(script, variables, notMathMetric, metrics, {
        reducedTimeRange,
        timeShift: series.offset_time
      });
    }
  }
  if (script === null) {
    return null;
  }

  // now replace the _interval with the new interval() formula
  if (script.includes('params._interval')) {
    script = script.replaceAll('params._interval', 'interval()');
  }
  const scripthasNoStaticNumber = isNaN(Number(script));
  if (script.includes('params') || !scripthasNoStaticNumber) {
    return null;
  }
  return createFormulaColumn(script, {
    series,
    metric,
    dataView
  });
};
exports.convertMathToFormulaColumn = convertMathToFormulaColumn;
const convertOtherAggsToFormulaColumn = (aggregation, {
  series,
  metrics,
  dataView
}, reducedTimeRange) => {
  var _metric$field$split, _metric$field;
  const metric = metrics[metrics.length - 1];
  const [fieldId, meta] = (_metric$field$split = metric === null || metric === void 0 ? void 0 : (_metric$field = metric.field) === null || _metric$field === void 0 ? void 0 : _metric$field.split('[')) !== null && _metric$field$split !== void 0 ? _metric$field$split : [];
  const subFunctionMetric = metrics.find(({
    id
  }) => id === fieldId);
  const metaValue = meta ? Number(meta === null || meta === void 0 ? void 0 : meta.replace(']', '')) : undefined;
  if (!subFunctionMetric) {
    return null;
  }
  const formula = (0, _metrics.getPipelineSeriesFormula)(metric, metrics, subFunctionMetric, {
    metaValue,
    reducedTimeRange,
    timeShift: series.offset_time
  });
  if (!formula) {
    return null;
  }
  return createFormulaColumn(formula, {
    series,
    metric,
    dataView
  });
};
exports.convertOtherAggsToFormulaColumn = convertOtherAggsToFormulaColumn;