"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSplitByTermsColor = void 0;
var _enums = require("../../../common/enums");
var _compute_gradient_final_color = require("./compute_gradient_final_color");
var _rainbow_colors = require("./rainbow_colors");
var _empty_label = require("../../../common/empty_label");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const getSplitByTermsColor = ({
  seriesById,
  seriesName,
  seriesId,
  baseColor,
  seriesPalette,
  palettesRegistry,
  syncColors
}) => {
  if (!seriesPalette) {
    return null;
  }
  const paletteName = seriesPalette.name === _enums.PALETTES.RAINBOW || seriesPalette.name === _enums.PALETTES.GRADIENT ? 'custom' : seriesPalette.name;
  const paletteParams = seriesPalette.name === _enums.PALETTES.GRADIENT ? {
    ...seriesPalette.params,
    colors: [baseColor, (0, _compute_gradient_final_color.computeGradientFinalColor)(baseColor)],
    gradient: true
  } : seriesPalette.name === _enums.PALETTES.RAINBOW ? {
    ...seriesPalette.params,
    colors: _rainbow_colors.rainbowColors
  } : seriesPalette.params;
  const outputColor = palettesRegistry === null || palettesRegistry === void 0 ? void 0 : palettesRegistry.get(paletteName || 'default').getCategoricalColor([{
    name: (0, _empty_label.getValueOrEmpty)(seriesName),
    rankAtDepth: seriesById.findIndex(({
      id
    }) => id === seriesId),
    totalSeriesAtDepth: seriesById.length
  }], {
    maxDepth: 1,
    totalSeries: seriesById.length,
    behindText: false,
    syncColors
  }, paletteParams);
  return outputColor;
};
exports.getSplitByTermsColor = getSplitByTermsColor;