"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FilterItems = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _react = _interopRequireWildcard(require("react"));
var _lodash = _interopRequireDefault(require("lodash"));
var _collection_actions = require("../lib/collection_actions");
var _add_delete_buttons = require("../add_delete_buttons");
var _color_picker = require("../color_picker");
var _uuid = require("uuid");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _get_default_query_language = require("../lib/get_default_query_language");
var _query_bar_wrapper = require("../query_bar_wrapper");
var _common = require("../../styles/common.styles");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

class FilterItemsUi extends _react.Component {
  constructor(props) {
    super(props);
    (0, _defineProperty2.default)(this, "handleQueryChange", (model, filter) => {
      const part = {
        filter
      };
      _collection_actions.collectionActions.handleChange(this.props, _lodash.default.assign({}, model, part));
    });
    this.renderRow = this.renderRow.bind(this);
  }
  handleChange(item, name) {
    return e => {
      const handleChange = _collection_actions.collectionActions.handleChange.bind(null, this.props);
      handleChange(_lodash.default.assign({}, item, {
        [name]: _lodash.default.get(e, 'value', _lodash.default.get(e, 'target.value'))
      }));
    };
  }
  renderRow(row, i, items) {
    const indexPatterns = this.props.indexPatterns;
    const defaults = {
      filter: '',
      label: ''
    };
    const model = {
      ...defaults,
      ...row
    };
    const handleChange = part => {
      const fn = _collection_actions.collectionActions.handleChange.bind(null, this.props);
      fn(_lodash.default.assign({}, model, part));
    };
    const newFilter = () => ({
      color: this.props.model.color,
      id: (0, _uuid.v1)(),
      filter: {
        language: model.filter.language || (0, _get_default_query_language.getDefaultQueryLanguage)(),
        query: ''
      }
    });
    const handleAdd = _collection_actions.collectionActions.handleAdd.bind(null, this.props, newFilter);
    const handleDelete = _collection_actions.collectionActions.handleDelete.bind(null, this.props, model);
    const {
      intl,
      theme
    } = this.props;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "s",
      css: (0, _common.tsvbEditorRowStyles)(theme.euiTheme),
      alignItems: "center",
      key: model.id
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_color_picker.ColorPicker, {
      disableTrash: true,
      onChange: handleChange,
      name: "color",
      value: model.color
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_query_bar_wrapper.QueryBarWrapper, {
      query: {
        language: model.filter.language || (0, _get_default_query_language.getDefaultQueryLanguage)(),
        query: model.filter.query || ''
      },
      onChange: query => this.handleQueryChange(model, query),
      indexPatterns: [indexPatterns],
      "data-test-subj": "filterItemsQueryBar"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
      placeholder: intl.formatMessage({
        id: 'visTypeTimeseries.splits.filterItems.labelPlaceholder',
        defaultMessage: 'Label'
      }),
      "aria-label": intl.formatMessage({
        id: 'visTypeTimeseries.splits.filterItems.labelAriaLabel',
        defaultMessage: 'Label'
      }),
      onChange: this.handleChange(model, 'label'),
      value: model.label,
      fullWidth: true,
      "data-test-subj": "filterItemsLabel"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_add_delete_buttons.AddDeleteButtons, {
      onAdd: handleAdd,
      onDelete: handleDelete,
      disableDelete: items.length < 2,
      responsive: false,
      testSubj: "filterRow"
    })));
  }
  render() {
    const {
      model,
      name
    } = this.props;
    if (!model[name]) return /*#__PURE__*/_react.default.createElement("div", null);
    const rows = model[name].map(this.renderRow);
    return /*#__PURE__*/_react.default.createElement("div", null, rows);
  }
}
FilterItemsUi.propTypes = {
  name: _propTypes.default.string,
  model: _propTypes.default.object,
  onChange: _propTypes.default.func,
  indexPatterns: _propTypes.default.string
};
const FilterItems = (0, _i18nReact.injectI18n)((0, _eui.withEuiTheme)(FilterItemsUi));
exports.FilterItems = FilterItems;