"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.QueryBarWrapper = QueryBarWrapper;
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/unified-search-plugin/public");
var _public2 = require("@kbn/kibana-react-plugin/public");
var _services = require("../../services");
var _index_patterns_utils = require("../../../common/index_patterns_utils");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function QueryBarWrapper({
  query,
  onChange,
  isInvalid,
  indexPatterns,
  'data-test-subj': dataTestSubj
}) {
  const dataViews = (0, _services.getDataViewsStart)();
  const [indexes, setIndexes] = (0, _react.useState)([]);
  const kibana = (0, _public2.useKibana)();
  const {
    appName,
    unifiedSearch,
    storage,
    data,
    notifications,
    http,
    docLinks,
    uiSettings,
    usageCollection
  } = kibana.services;
  (0, _react.useEffect)(() => {
    async function fetchIndexes() {
      const i = [];
      for (const index of indexPatterns !== null && indexPatterns !== void 0 ? indexPatterns : []) {
        if (index) {
          if ((0, _index_patterns_utils.isStringTypeIndexPattern)(index)) {
            i.push(index);
          } else if (index !== null && index !== void 0 && index.id) {
            const {
              indexPattern
            } = await (0, _index_patterns_utils.fetchIndexPattern)(index, dataViews);
            if (indexPattern) {
              i.push(indexPattern);
            }
          }
        } else {
          const defaultIndex = await dataViews.getDefault();
          if (defaultIndex) {
            i.push(defaultIndex);
          }
        }
      }
      setIndexes(i);
    }
    fetchIndexes();
  }, [indexPatterns, dataViews]);
  return /*#__PURE__*/_react.default.createElement(_public.QueryStringInput, {
    appName: appName,
    deps: {
      unifiedSearch,
      notifications,
      http,
      docLinks,
      uiSettings,
      data,
      dataViews,
      storage,
      usageCollection
    },
    query: query,
    onChange: onChange,
    isInvalid: isInvalid,
    indexPatterns: indexes,
    dataTestSubj: dataTestSubj
  });
}