"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MetricPanelConfig = void 0;
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireWildcard(require("react"));
var _uuid = require("uuid");
var _eui = require("@elastic/eui");
var _series_editor = require("../series_editor");
var _index_pattern = require("../index_pattern");
var _color_rules = require("../color_rules");
var _yes_no = require("../yes_no");
var _query_bar_wrapper = require("../query_bar_wrapper");
var _get_default_query_language = require("../lib/get_default_query_language");
var _ui_restrictions = require("../../../../common/ui_restrictions");
var _enums = require("../../../../common/enums");
var _types = require("./types");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

class MetricPanelConfig extends _react.Component {
  constructor(props) {
    super(props);
    this.state = {
      selectedTab: _types.PANEL_CONFIG_TABS.DATA
    };
  }
  UNSAFE_componentWillMount() {
    const {
      model
    } = this.props;
    if (!model.background_color_rules || model.background_color_rules && model.background_color_rules.length === 0) {
      this.props.onChange({
        background_color_rules: [{
          id: (0, _uuid.v1)()
        }]
      });
    }
  }
  switchTab(selectedTab) {
    this.setState({
      selectedTab
    });
  }
  render() {
    var _model$filter, _model$filter2;
    const {
      selectedTab
    } = this.state;
    const defaults = {
      filter: {
        query: '',
        language: (0, _get_default_query_language.getDefaultQueryLanguage)()
      }
    };
    const model = {
      ...defaults,
      ...this.props.model
    };
    const htmlId = (0, _eui.htmlIdGenerator)();
    const view = selectedTab === _types.PANEL_CONFIG_TABS.DATA ? /*#__PURE__*/_react.default.createElement(_series_editor.SeriesEditor, {
      colorPicker: false,
      fields: this.props.fields,
      limit: _ui_restrictions.limitOfSeries[_enums.PANEL_TYPES.METRIC],
      model: this.props.model,
      onChange: this.props.onChange
    }) : /*#__PURE__*/_react.default.createElement("div", {
      className: "tvbPanelConfig__container"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "s"
    }, /*#__PURE__*/_react.default.createElement("span", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "visTypeTimeseries.metric.optionsTab.dataLabel",
      defaultMessage: "Data"
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m"
    }), /*#__PURE__*/_react.default.createElement(_index_pattern.IndexPattern, {
      fields: this.props.fields,
      model: this.props.model,
      onChange: this.props.onChange,
      allowIndexSwitchingMode: true
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      responsive: false,
      wrap: true
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      id: htmlId('panelFilter'),
      label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "visTypeTimeseries.metric.optionsTab.panelFilterLabel",
        defaultMessage: "Panel filter"
      }),
      fullWidth: true
    }, /*#__PURE__*/_react.default.createElement(_query_bar_wrapper.QueryBarWrapper, {
      query: {
        language: ((_model$filter = model.filter) === null || _model$filter === void 0 ? void 0 : _model$filter.language) || (0, _get_default_query_language.getDefaultQueryLanguage)(),
        query: ((_model$filter2 = model.filter) === null || _model$filter2 === void 0 ? void 0 : _model$filter2.query) || ''
      },
      onChange: filter => {
        this.props.onChange({
          filter
        });
      },
      indexPatterns: [model.index_pattern]
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: _i18n.i18n.translate('visTypeTimeseries.metric.optionsTab.ignoreGlobalFilterLabel', {
        defaultMessage: 'Ignore global filter?'
      })
    }, /*#__PURE__*/_react.default.createElement(_yes_no.YesNo, {
      value: model.ignore_global_filter,
      name: "ignore_global_filter",
      onChange: this.props.onChange
    }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "s"
    }, /*#__PURE__*/_react.default.createElement("span", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "visTypeTimeseries.metric.optionsTab.colorRulesLabel",
      defaultMessage: "Color rules"
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m"
    }), /*#__PURE__*/_react.default.createElement(_color_rules.ColorRules, {
      model: model,
      onChange: this.props.onChange,
      name: "background_color_rules"
    })));
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTabs, {
      size: "s"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
      isSelected: selectedTab === _types.PANEL_CONFIG_TABS.DATA,
      onClick: () => this.switchTab(_types.PANEL_CONFIG_TABS.DATA),
      "data-test-subj": "metricEditorDataBtn"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "visTypeTimeseries.metric.dataTab.dataButtonLabel",
      defaultMessage: "Data"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
      isSelected: selectedTab === _types.PANEL_CONFIG_TABS.OPTIONS,
      onClick: () => this.switchTab(_types.PANEL_CONFIG_TABS.OPTIONS),
      "data-test-subj": "metricEditorPanelOptionsBtn"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "visTypeTimeseries.metric.optionsTab.panelOptionsButtonLabel",
      defaultMessage: "Panel options"
    }))), view);
  }
}
exports.MetricPanelConfig = MetricPanelConfig;