"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IndexPattern = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _lodash = require("lodash");
var _propTypes = _interopRequireDefault(require("prop-types"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _field_select = require("./aggs/field_select");
var _create_select_handler = require("./lib/create_select_handler");
var _create_text_handler = require("./lib/create_text_handler");
var _index_pattern_select = require("./lib/index_pattern_select");
var _yes_no = require("./yes_no");
var _last_value_mode_popover = require("./last_value_mode_popover");
var _public = require("@kbn/data-plugin/public");
var _get_interval = require("./lib/get_interval");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _enums = require("../../../common/enums");
var _constants = require("../../../common/constants");
var _check_ui_restrictions = require("../../../common/check_ui_restrictions");
var _vis_data_context = require("../contexts/vis_data_context");
var _panel_model_context = require("../contexts/panel_model_context");
var _form_validation_context = require("../contexts/form_validation_context");
var _services = require("../../services");
var _common = require("@kbn/data-plugin/common");
var _index_patterns_utils = require("../../../common/index_patterns_utils");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const RESTRICT_FIELDS = [_public.KBN_FIELD_TYPES.DATE];
const LEVEL_OF_DETAIL_STEPS = 10;
const LEVEL_OF_DETAIL_MIN_BUCKETS = 1;
const HIDE_LAST_VALUE_INDICATOR = 'hide_last_value_indicator';
const validateIntervalValue = intervalValue => {
  const isAutoOrGteInterval = (0, _get_interval.isGteInterval)(intervalValue) || (0, _get_interval.isAutoInterval)(intervalValue);
  if (isAutoOrGteInterval) {
    return {
      isValid: true
    };
  }
  return (0, _get_interval.validateReInterval)(intervalValue);
};
const htmlId = (0, _eui.htmlIdGenerator)();
const isEntireTimeRangeActive = (model, isTimeSeries) => !isTimeSeries && model[_enums.TIME_RANGE_MODE_KEY] === _enums.TIME_RANGE_DATA_MODES.ENTIRE_TIME_RANGE;
const IndexPattern = ({
  fields,
  prefix,
  onChange,
  disabled,
  model: _model,
  allowLevelOfDetail,
  allowIndexSwitchingMode,
  baseIndexPattern
}) => {
  var _fetchedIndex$indexPa, _fetchedIndex$indexPa2, _fetchedIndex$default;
  const config = (0, _services.getUISettings)();
  const timeFieldName = `${prefix}time_field`;
  const indexPatternName = `${prefix}index_pattern`;
  const intervalName = `${prefix}interval`;
  const maxBarsName = `${prefix}max_bars`;
  const dropBucketName = `${prefix}drop_last_bucket`;
  const updateControlValidity = (0, _react.useContext)(_form_validation_context.FormValidationContext);
  const panelModel = (0, _react.useContext)(_panel_model_context.PanelModelContext);
  const uiRestrictions = (0, _lodash.get)((0, _react.useContext)(_vis_data_context.VisDataContext), 'uiRestrictions');
  const maxBarsUiSettings = config.get(_common.UI_SETTINGS.HISTOGRAM_MAX_BARS);
  const [fetchedIndex, setFetchedIndex] = (0, _react.useState)(null);
  const isTimeSeries = panelModel.type === _enums.PANEL_TYPES.TIMESERIES;
  const handleMaxBarsChange = (0, _react.useCallback)(({
    target
  }) => {
    onChange({
      [maxBarsName]: Math.max(LEVEL_OF_DETAIL_MIN_BUCKETS, target.value)
    });
  }, [onChange, maxBarsName]);
  const handleSelectChange = (0, _create_select_handler.createSelectHandler)(onChange);
  const handleTextChange = (0, _create_text_handler.createTextHandler)(onChange);
  const timeRangeOptions = [{
    label: _i18n.i18n.translate('visTypeTimeseries.indexPattern.timeRange.entireTimeRange', {
      defaultMessage: 'Entire time range'
    }),
    value: _enums.TIME_RANGE_DATA_MODES.ENTIRE_TIME_RANGE,
    disabled: !(0, _check_ui_restrictions.isTimerangeModeEnabled)(_enums.TIME_RANGE_DATA_MODES.ENTIRE_TIME_RANGE, uiRestrictions)
  }, {
    label: _i18n.i18n.translate('visTypeTimeseries.indexPattern.timeRange.lastValue', {
      defaultMessage: 'Last value'
    }),
    value: _enums.TIME_RANGE_DATA_MODES.LAST_VALUE,
    disabled: !(0, _check_ui_restrictions.isTimerangeModeEnabled)(_enums.TIME_RANGE_DATA_MODES.LAST_VALUE, uiRestrictions)
  }];
  const defaults = {
    [indexPatternName]: '',
    [intervalName]: _constants.AUTO_INTERVAL,
    [dropBucketName]: 0,
    [maxBarsName]: config.get(_common.UI_SETTINGS.HISTOGRAM_BAR_TARGET),
    [_enums.TIME_RANGE_MODE_KEY]: timeRangeOptions[0].value
  };
  const model = {
    ...defaults,
    ..._model
  };
  const index = model[indexPatternName];
  const intervalValidation = validateIntervalValue(model[intervalName]);
  const selectedTimeRangeOption = timeRangeOptions.find(({
    value
  }) => model[_enums.TIME_RANGE_MODE_KEY] === value);
  const isDataTimerangeModeInvalid = !disabled && selectedTimeRangeOption && !(0, _check_ui_restrictions.isTimerangeModeEnabled)(selectedTimeRangeOption.value, uiRestrictions);
  (0, _react.useEffect)(() => {
    updateControlValidity(intervalName, intervalValidation.isValid);
  }, [intervalName, intervalValidation.isValid, updateControlValidity]);
  (0, _react.useEffect)(() => {
    async function fetchIndex() {
      const dataViews = (0, _services.getDataViewsStart)();
      let fetchedIndexPattern = {
        indexPattern: undefined,
        indexPatternString: undefined
      };
      const indexPatternToFetch = index || baseIndexPattern;
      try {
        fetchedIndexPattern = indexPatternToFetch ? await (0, _index_patterns_utils.fetchIndexPattern)(indexPatternToFetch, dataViews, {
          fetchKibanaIndexForStringIndexes: true
        }) : {
          ...fetchedIndexPattern,
          defaultIndex: await dataViews.getDefault()
        };
      } catch {
        if ((0, _index_patterns_utils.isDataViewTypeIndexPattern)(index)) {
          fetchedIndexPattern.missedIndex = index.id;
        }
      }
      setFetchedIndex(fetchedIndexPattern);
    }
    fetchIndex();
  }, [index, baseIndexPattern]);
  const toggleIndicatorDisplay = (0, _react.useCallback)(() => onChange({
    [HIDE_LAST_VALUE_INDICATOR]: !model.hide_last_value_indicator
  }), [model.hide_last_value_indicator, onChange]);
  return /*#__PURE__*/_react.default.createElement("div", {
    className: "index-pattern"
  }, !isTimeSeries && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    id: htmlId('timeRange'),
    label: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "visTypeTimeseries.indexPattern.timeRange.label",
      defaultMessage: "Data timerange mode"
    }), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      position: "right",
      content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "visTypeTimeseries.indexPattern.timeRange.hint",
        defaultMessage: "This setting controls the timespan used for matching documents. \"Entire timerange\" will match all the documents selected in the timepicker. \"Last value\" will match only the documents for the specified interval from the end of the timerange."
      }),
      type: "questionInCircle"
    })),
    isInvalid: isDataTimerangeModeInvalid,
    error: _i18n.i18n.translate('visTypeTimeseries.indexPattern.timeRange.error', {
      defaultMessage: 'You cannot use "{mode}" with the current index type.',
      values: {
        mode: selectedTimeRangeOption === null || selectedTimeRangeOption === void 0 ? void 0 : selectedTimeRangeOption.label
      }
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, (0, _extends2.default)({
    "data-test-subj": "dataTimeRangeMode",
    isClearable: false,
    isInvalid: isDataTimerangeModeInvalid,
    placeholder: _i18n.i18n.translate('visTypeTimeseries.indexPattern.timeRange.selectTimeRange', {
      defaultMessage: 'Select'
    }),
    options: timeRangeOptions,
    error: _i18n.i18n.translate('visTypeTimeseries.indexPattern.timeRange.entireTimeRange', {
      defaultMessage: 'Entire time range'
    }),
    selectedOptions: selectedTimeRangeOption ? [selectedTimeRangeOption] : [],
    onChange: handleSelectChange(_enums.TIME_RANGE_MODE_KEY),
    singleSelection: {
      asPlainText: true
    },
    isDisabled: disabled
  }, !isEntireTimeRangeActive(model, isTimeSeries) && {
    append: /*#__PURE__*/_react.default.createElement(_last_value_mode_popover.LastValueModePopover, {
      isIndicatorDisplayed: !model.hide_last_value_indicator,
      toggleIndicatorDisplay: toggleIndicatorDisplay
    })
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_index_pattern_select.IndexPatternSelect, {
    fetchedIndex: fetchedIndex,
    indexPatternName: indexPatternName,
    onChange: onChange,
    disabled: disabled,
    allowIndexSwitchingMode: allowIndexSwitchingMode
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_field_select.FieldSelect, {
    label: _i18n.i18n.translate('visTypeTimeseries.indexPattern.timeFieldLabel', {
      defaultMessage: 'Time field'
    }),
    restrict: RESTRICT_FIELDS,
    value: model[timeFieldName],
    disabled: disabled,
    onChange: value => onChange({
      [timeFieldName]: value === null || value === void 0 ? void 0 : value[0]
    }),
    indexPattern: model[indexPatternName],
    fields: fields,
    placeholder: (_fetchedIndex$indexPa = fetchedIndex === null || fetchedIndex === void 0 ? void 0 : (_fetchedIndex$indexPa2 = fetchedIndex.indexPattern) === null || _fetchedIndex$indexPa2 === void 0 ? void 0 : _fetchedIndex$indexPa2.timeFieldName) !== null && _fetchedIndex$indexPa !== void 0 ? _fetchedIndex$indexPa : fetchedIndex === null || fetchedIndex === void 0 ? void 0 : (_fetchedIndex$default = fetchedIndex.defaultIndex) === null || _fetchedIndex$default === void 0 ? void 0 : _fetchedIndex$default.timeFieldName
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    isInvalid: !intervalValidation.isValid,
    error: intervalValidation.errorMessage,
    id: htmlId('interval'),
    label: _i18n.i18n.translate('visTypeTimeseries.indexPattern.intervalLabel', {
      defaultMessage: 'Interval'
    }),
    helpText: _i18n.i18n.translate('visTypeTimeseries.indexPattern.intervalHelpText', {
      defaultMessage: 'Examples: auto, 1m, 1d, 7d, 1y, >=1m',
      description: 'auto, 1m, 1d, 7d, 1y, >=1m are required values and must not be translated.'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    "data-test-subj": "metricsIndexPatternInterval",
    isInvalid: !intervalValidation.isValid,
    disabled: disabled || isEntireTimeRangeActive(model, isTimeSeries),
    onChange: handleTextChange(intervalName, _constants.AUTO_INTERVAL),
    value: model[intervalName],
    placeholder: _constants.AUTO_INTERVAL
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    id: htmlId('dropLastBucket'),
    label: _i18n.i18n.translate('visTypeTimeseries.indexPattern.dropLastBucketLabel', {
      defaultMessage: 'Drop last bucket?'
    })
  }, /*#__PURE__*/_react.default.createElement(_yes_no.YesNo, {
    "data-test-subj": "metricsDropLastBucket",
    value: model[dropBucketName],
    name: dropBucketName,
    onChange: onChange,
    disabled: disabled || isEntireTimeRangeActive(model, isTimeSeries)
  })))), allowLevelOfDetail && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    id: htmlId('detailLevel'),
    label: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "visTypeTimeseries.indexPattern.detailLevel",
      defaultMessage: "Level of detail"
    }), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      position: "right",
      content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "visTypeTimeseries.indexPattern.detailLevelHelpText",
        defaultMessage: "Controls the auto and gte intervals based on the time range. The default interval is affected by the advanced settings {histogramTargetBars} and {histogramMaxBars}.",
        values: {
          histogramTargetBars: _common.UI_SETTINGS.HISTOGRAM_MAX_BARS,
          histogramMaxBars: _common.UI_SETTINGS.HISTOGRAM_BAR_TARGET
        }
      }),
      type: "questionInCircle"
    }))
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormLabel, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "visTypeTimeseries.indexPattern.\u0441oarse",
    defaultMessage: "Coarse"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiRange, {
    id: (0, _eui.htmlIdGenerator)()(),
    value: model[maxBarsName],
    onChange: handleMaxBarsChange,
    disabled: disabled || isEntireTimeRangeActive(model, isTimeSeries) || !((0, _get_interval.isAutoInterval)(model[intervalName]) || (0, _get_interval.isGteInterval)(model[intervalName])),
    min: 0,
    max: maxBarsUiSettings,
    step: maxBarsUiSettings / LEVEL_OF_DETAIL_STEPS,
    "aria-label": _i18n.i18n.translate('visTypeTimeseries.indexPattern.detailLevelAriaLabel', {
      defaultMessage: 'Level of detail'
    })
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormLabel, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "visTypeTimeseries.indexPattern.finest",
    defaultMessage: "Finest"
  }))))))));
};
exports.IndexPattern = IndexPattern;
IndexPattern.defaultProps = {
  prefix: '',
  disabled: false
};
IndexPattern.propTypes = {
  baseIndexPattern: _propTypes.default.oneOf([_propTypes.default.object, _propTypes.default.string]),
  model: _propTypes.default.object.isRequired,
  fields: _propTypes.default.object.isRequired,
  onChange: _propTypes.default.func.isRequired,
  prefix: _propTypes.default.string,
  disabled: _propTypes.default.bool,
  className: _propTypes.default.string,
  allowLevelOfDetail: _propTypes.default.bool,
  allowIndexSwitchingMode: _propTypes.default.bool
};