"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.newVariable = exports.CalculationVars = void 0;
var _propTypes = _interopRequireDefault(require("prop-types"));
var _react = _interopRequireWildcard(require("react"));
var _uuid = require("uuid");
var _i18n = require("@kbn/i18n");
var _lodash = _interopRequireDefault(require("lodash"));
var _add_delete_buttons = require("../add_delete_buttons");
var _collection_actions = require("../lib/collection_actions");
var _metric_select = require("./metric_select");
var _eui = require("@elastic/eui");
var _index_patterns_utils = require("../../../../common/index_patterns_utils");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const newVariable = opts => ({
  id: (0, _uuid.v1)(),
  name: '',
  field: '',
  ...opts
});
exports.newVariable = newVariable;
class CalculationVars extends _react.Component {
  constructor(props) {
    super(props);
    this.renderRow = this.renderRow.bind(this);
  }
  handleChange(item, name) {
    return e => {
      const handleChange = _collection_actions.collectionActions.handleChange.bind(null, this.props);
      const part = {};
      part[name] = _lodash.default.get(e, '[0].value', _lodash.default.get(e, 'target.value'));
      handleChange(_lodash.default.assign({}, item, part));
    };
  }
  renderRow(row, i, items) {
    const handleAdd = _collection_actions.collectionActions.handleAdd.bind(null, this.props, newVariable);
    const handleDelete = _collection_actions.collectionActions.handleDelete.bind(null, this.props, row);
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      key: row.id,
      "data-test-subj": "varRow"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      responsive: false,
      gutterSize: "s"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
      className: "tvbAggs__varName",
      "aria-label": _i18n.i18n.translate('visTypeTimeseries.vars.variableNameAriaLabel', {
        defaultMessage: 'Variable name'
      }),
      placeholder: _i18n.i18n.translate('visTypeTimeseries.vars.variableNamePlaceholder', {
        defaultMessage: 'Variable name'
      }),
      onChange: this.handleChange(row, 'name'),
      value: row.name
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      className: "tvbAggs__varMetricWrapper"
    }, /*#__PURE__*/_react.default.createElement(_metric_select.MetricSelect, {
      onChange: this.handleChange(row, 'field'),
      metrics: this.props.metrics,
      metric: this.props.model,
      value: row.field,
      fields: this.props.fields[(0, _index_patterns_utils.getIndexPatternKey)(this.props.indexPattern)],
      includeSiblings: this.props.includeSiblings,
      exclude: this.props.exclude
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_add_delete_buttons.AddDeleteButtons, {
      onAdd: handleAdd,
      onDelete: handleDelete,
      disableDelete: items.length < 2,
      responsive: false
    }))));
  }
  render() {
    const {
      model,
      name
    } = this.props;
    if (!model[name]) return /*#__PURE__*/_react.default.createElement("div", null);
    const rows = model[name].map(this.renderRow);
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "column",
      gutterSize: "s"
    }, rows);
  }
}
exports.CalculationVars = CalculationVars;
CalculationVars.defaultProps = {
  name: 'variables',
  includeSiblings: false
};
CalculationVars.propTypes = {
  fields: _propTypes.default.object,
  indexPattern: _propTypes.default.oneOfType([_propTypes.default.string, _propTypes.default.object]),
  metrics: _propTypes.default.array,
  model: _propTypes.default.object,
  name: _propTypes.default.string,
  onChange: _propTypes.default.func,
  includeSiblings: _propTypes.default.bool
};