"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FilterRatioAgg = void 0;
var _propTypes = _interopRequireDefault(require("prop-types"));
var _react = _interopRequireWildcard(require("react"));
var _agg_select = require("./agg_select");
var _field_select = require("./field_select");
var _agg_row = require("./agg_row");
var _create_change_handler = require("../lib/create_change_handler");
var _create_select_handler = require("../lib/create_select_handler");
var _index_patterns_utils = require("../../../../common/index_patterns_utils");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/data-plugin/public");
var _get_supported_fields_by_metric_type = require("../lib/get_supported_fields_by_metric_type");
var _services = require("../../../services");
var _query_bar_wrapper = require("../query_bar_wrapper");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const isFieldHistogram = (fields, indexPattern, field) => {
  const indexFields = fields[(0, _index_patterns_utils.getIndexPatternKey)(indexPattern)];
  if (!indexFields) return false;
  const fieldObject = indexFields.find(f => f.name === field);
  if (!fieldObject) return false;
  return fieldObject.type === _public.KBN_FIELD_TYPES.HISTOGRAM;
};
const FilterRatioAgg = props => {
  const {
    series,
    fields,
    panel
  } = props;
  const handleChange = (0, _react.useMemo)(() => (0, _create_change_handler.createChangeHandler)(props.onChange, props.model), [props.model, props.onChange]);
  const handleSelectChange = (0, _create_select_handler.createSelectHandler)(handleChange);
  const handleNumeratorQueryChange = (0, _react.useCallback)(query => handleChange({
    numerator: query
  }), [handleChange]);
  const handleDenominatorQueryChange = (0, _react.useCallback)(query => handleChange({
    denominator: query
  }), [handleChange]);
  const indexPattern = series.override_index_pattern ? series.series_index_pattern : panel.index_pattern;
  const defaults = {
    numerator: (0, _services.getDataStart)().query.queryString.getDefaultQuery(),
    denominator: (0, _services.getDataStart)().query.queryString.getDefaultQuery(),
    metric_agg: 'count'
  };
  const model = {
    ...defaults,
    ...props.model
  };
  const htmlId = (0, _eui.htmlIdGenerator)();
  return /*#__PURE__*/_react.default.createElement(_agg_row.AggRow, {
    disableDelete: props.disableDelete,
    model: props.model,
    onAdd: props.onAdd,
    onDelete: props.onDelete,
    siblings: props.siblings,
    dragHandleProps: props.dragHandleProps
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormLabel, {
    htmlFor: htmlId('aggregation')
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "visTypeTimeseries.filterRatio.aggregationLabel",
    defaultMessage: "Aggregation"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  }), /*#__PURE__*/_react.default.createElement(_agg_select.AggSelect, {
    id: htmlId('aggregation'),
    panelType: props.panel.type,
    siblings: props.siblings,
    value: model.type,
    onChange: handleSelectChange('type')
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    id: htmlId('numerator'),
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "visTypeTimeseries.filterRatio.numeratorLabel",
      defaultMessage: "Numerator"
    })
  }, /*#__PURE__*/_react.default.createElement(_query_bar_wrapper.QueryBarWrapper, {
    query: model.numerator,
    onChange: handleNumeratorQueryChange,
    indexPatterns: [indexPattern],
    "data-test-subj": "filterRatioNumeratorInput"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    id: htmlId('denominator'),
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "visTypeTimeseries.filterRatio.denominatorLabel",
      defaultMessage: "Denominator"
    })
  }, /*#__PURE__*/_react.default.createElement(_query_bar_wrapper.QueryBarWrapper, {
    query: model.denominator,
    onChange: handleDenominatorQueryChange,
    indexPatterns: [indexPattern],
    "data-test-subj": "filterRatioDenominatorInput"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormLabel, {
    htmlFor: htmlId('metric')
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "visTypeTimeseries.filterRatio.metricAggregationLabel",
    defaultMessage: "Metric Aggregation"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  }), /*#__PURE__*/_react.default.createElement(_agg_select.AggSelect, {
    id: htmlId('metric'),
    siblings: props.siblings,
    panelType: isFieldHistogram(fields, indexPattern, model.field) ? 'histogram' : 'filter_ratio',
    value: model.metric_agg,
    onChange: handleSelectChange('metric_agg')
  })), model.metric_agg !== 'count' ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_field_select.FieldSelect, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "visTypeTimeseries.filterRatio.fieldLabel",
      defaultMessage: "Field"
    }),
    fields: fields,
    type: model.metric_agg,
    restrict: (0, _get_supported_fields_by_metric_type.getSupportedFieldsByMetricType)(model.metric_agg),
    indexPattern: indexPattern,
    value: model.field,
    onChange: value => handleChange({
      field: value === null || value === void 0 ? void 0 : value[0]
    })
  })) : null));
};
exports.FilterRatioAgg = FilterRatioAgg;
FilterRatioAgg.propTypes = {
  disableDelete: _propTypes.default.bool,
  fields: _propTypes.default.object,
  model: _propTypes.default.object,
  onAdd: _propTypes.default.func,
  onChange: _propTypes.default.func,
  onDelete: _propTypes.default.func,
  panel: _propTypes.default.object,
  series: _propTypes.default.object,
  siblings: _propTypes.default.array
};