"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getTimezone = getTimezone;
var _momentTimezone = _interopRequireDefault(require("moment-timezone"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function getTimezone(config) {
  if (config.isDefault('dateFormat:tz')) {
    const detectedTimezone = _momentTimezone.default.tz.guess();
    if (detectedTimezone) return detectedTimezone;else return (0, _momentTimezone.default)().format('Z');
  } else {
    return config.get('dateFormat:tz', 'Browser');
  }
}