"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.tableVisResponseHandler = tableVisResponseHandler;
var _services = require("../services");
var _add_percentage_column = require("./add_percentage_column");
var _create_formatted_table = require("./create_formatted_table");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * Converts datatable input from response into appropriate format for consuming renderer
 */
function tableVisResponseHandler(input, visConfig) {
  const tables = [];
  let table;
  let direction;
  const split = visConfig.splitColumn || visConfig.splitRow;
  if (split) {
    direction = visConfig.splitRow ? 'row' : 'column';
    const splitColumnIndex = split.accessor;
    const splitColumnFormatter = (0, _services.getFormatService)().deserialize(split.format);
    const splitColumn = input.columns[splitColumnIndex];
    const splitMap = {};
    let splitIndex = 0;
    input.rows.forEach(row => {
      const splitValue = row[splitColumn.id];
      if (!splitMap.hasOwnProperty(splitValue)) {
        splitMap[splitValue] = splitIndex++;
        const tableGroup = {
          title: `${splitColumnFormatter.convert(splitValue)}: ${splitColumn.name}`,
          table: {
            columns: input.columns,
            rows: [],
            formattedColumns: {}
          }
        };
        tables.push(tableGroup);
      }
      const tableIndex = splitMap[splitValue];
      tables[tableIndex].table.rows.push(row);
    });
    tables.forEach(tg => {
      tg.table = (0, _create_formatted_table.createFormattedTable)(tg.table, visConfig);
      if (visConfig.percentageCol) {
        tg.table = (0, _add_percentage_column.addPercentageColumn)(tg.table, visConfig.percentageCol);
      }
    });
  } else {
    table = (0, _create_formatted_table.createFormattedTable)(input, visConfig);
    if (visConfig.percentageCol) {
      table = (0, _add_percentage_column.addPercentageColumn)(table, visConfig.percentageCol);
    }
  }
  return {
    direction,
    table,
    tables
  };
}