"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MetricVisPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _metric_vis_type = require("./metric_vis_type");
var _services = require("./services");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/** @internal */
class MetricVisPlugin {
  constructor(initializerContext) {
    (0, _defineProperty2.default)(this, "initializerContext", void 0);
    this.initializerContext = initializerContext;
  }
  setup(core, {
    visualizations
  }) {
    const {
      readOnly
    } = this.initializerContext.config.get();
    visualizations.createBaseVisualization({
      ...(0, _metric_vis_type.createMetricVisTypeDefinition)(),
      disableCreate: Boolean(readOnly),
      disableEdit: Boolean(readOnly)
    });
  }
  start(core, {
    dataViews
  }) {
    (0, _services.setDataViewsStart)(dataViews);
  }
}
exports.MetricVisPlugin = MetricVisPlugin;