"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MarkdownPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _markdown_vis = require("./markdown_vis");
var _markdown_fn = require("./markdown_fn");
var _markdown_renderer = require("./markdown_renderer");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/** @internal */
class MarkdownPlugin {
  constructor(initializerContext) {
    (0, _defineProperty2.default)(this, "initializerContext", void 0);
    this.initializerContext = initializerContext;
  }
  setup(core, {
    expressions,
    visualizations
  }) {
    visualizations.createBaseVisualization(_markdown_vis.markdownVisDefinition);
    expressions.registerRenderer(_markdown_renderer.markdownVisRenderer);
    expressions.registerFunction(_markdown_fn.createMarkdownVisFn);
  }
  start(core) {
    // nothing to do here yet
  }
}
exports.MarkdownPlugin = MarkdownPlugin;