"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CsmSharedContext = void 0;
exports.CsmSharedContextProvider = CsmSharedContextProvider;
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/kibana-react-plugin/public");
var _use_dynamic_data_view = require("../../../../hooks/use_dynamic_data_view");
var _use_fetcher = require("../../../../hooks/use_fetcher");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const defaultContext = {
  sharedData: {
    totalPageViews: 0
  },
  setSharedData: d => {
    throw new Error('setSharedData was not initialized, set it when you invoke the context');
  }
};
const CsmSharedContext = /*#__PURE__*/(0, _react.createContext)(defaultContext);
exports.CsmSharedContext = CsmSharedContext;
function CsmSharedContextProvider({
  children
}) {
  const [newData, setNewData] = (0, _react.useState)({
    totalPageViews: 0
  });
  const [dataView, setDataView] = (0, _react.useState)();
  const setSharedData = _react.default.useCallback(data => {
    setNewData(data);
  }, []);
  const {
    services: {
      dataViews
    }
  } = (0, _public.useKibana)();
  const {
    dataViewTitle
  } = (0, _use_dynamic_data_view.useDynamicDataViewTitle)();
  const {
    data
  } = (0, _use_fetcher.useFetcher)(async () => {
    if (dataViewTitle) {
      return dataViews.create({
        title: dataViewTitle,
        timeFieldName: '@timestamp'
      });
    }
  }, [dataViewTitle, dataViews]);
  (0, _react.useEffect)(() => {
    setDataView(data);
  }, [data]);
  const value = (0, _react.useMemo)(() => {
    return {
      sharedData: newData,
      setSharedData,
      dataView
    };
  }, [newData, setSharedData, dataView]);
  return /*#__PURE__*/_react.default.createElement(CsmSharedContext.Provider, {
    value: value,
    children: children
  });
}