"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UrlDrilldown = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireDefault(require("react"));
var _public = require("@kbn/embeddable-plugin/public");
var _public2 = require("@kbn/image-embeddable-plugin/public");
var _public3 = require("@kbn/ui-actions-plugin/public");
var _public4 = require("@kbn/kibana-react-plugin/public");
var _public5 = require("@kbn/ui-actions-enhanced-plugin/public");
var _i18n = require("./i18n");
var _event_variables = require("./variables/event_variables");
var _context_variables = require("./variables/context_variables");
var _global_variables = require("./variables/global_variables");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const URL_DRILLDOWN = 'URL_DRILLDOWN';
class UrlDrilldown {
  constructor(deps) {
    (0, _defineProperty2.default)(this, "id", URL_DRILLDOWN);
    (0, _defineProperty2.default)(this, "order", 8);
    (0, _defineProperty2.default)(this, "minimalLicense", 'gold');
    (0, _defineProperty2.default)(this, "licenseFeatureName", 'URL drilldown');
    (0, _defineProperty2.default)(this, "getDisplayName", () => _i18n.txtUrlDrilldownDisplayName);
    (0, _defineProperty2.default)(this, "actionMenuItem", ({
      config,
      context
    }) => {
      const [title, setTitle] = _react.default.useState(config.name);
      _react.default.useEffect(() => {
        let unmounted = false;
        const variables = this.getRuntimeVariables(context);
        (0, _public5.urlDrilldownCompileUrl)(title, variables, false).then(result => {
          if (unmounted) return;
          if (title !== result) setTitle(result);
        }).catch(() => {});
        return () => {
          unmounted = true;
        };
      });
      return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, title);
    });
    (0, _defineProperty2.default)(this, "euiIcon", 'link');
    (0, _defineProperty2.default)(this, "CollectConfig", ({
      config,
      onConfig,
      context
    }) => {
      const [variables, exampleUrl] = _react.default.useMemo(() => [this.getVariableList(context), this.getExampleUrl(context)], [context]);
      return /*#__PURE__*/_react.default.createElement(_public4.KibanaContextProvider, {
        services: {
          settings: this.deps.settings,
          theme: this.deps.theme()
        }
      }, /*#__PURE__*/_react.default.createElement(_public5.UrlDrilldownCollectConfig, {
        variables: variables,
        exampleUrl: exampleUrl,
        config: config,
        onConfig: onConfig,
        syntaxHelpDocsLink: this.deps.getSyntaxHelpDocsLink(),
        variablesHelpDocsLink: this.deps.getVariablesHelpDocsLink()
      }));
    });
    (0, _defineProperty2.default)(this, "createConfig", () => ({
      url: {
        template: ''
      },
      openInNewTab: true,
      encodeUrl: true
    }));
    (0, _defineProperty2.default)(this, "isConfigValid", config => {
      return !!config.url.template;
    });
    (0, _defineProperty2.default)(this, "isCompatible", async (config, context) => {
      const scope = this.getRuntimeVariables(context);
      const {
        isValid,
        error
      } = await (0, _public5.urlDrilldownValidateUrlTemplate)(config.url, scope);
      if (!isValid) {
        // eslint-disable-next-line no-console
        console.warn(`UrlDrilldown [${config.url.template}] is not valid. Error [${error}]. Skipping execution.`);
        return false;
      }
      const url = await this.buildUrl(config, context);
      const validUrl = this.deps.externalUrl.validateUrl(url);
      if (!validUrl) {
        return false;
      }
      return true;
    });
    (0, _defineProperty2.default)(this, "getHref", async (config, context) => {
      const url = await this.buildUrl(config, context);
      const validUrl = this.deps.externalUrl.validateUrl(url);
      if (!validUrl) {
        throw new Error(`External URL [${url}] was denied by ExternalUrl service. ` + `You can configure external URL policies using "externalUrl.policy" setting in kibana.yml.`);
      }
      return url;
    });
    (0, _defineProperty2.default)(this, "execute", async (config, context) => {
      const url = await this.getHref(config, context);
      if (config.openInNewTab) {
        window.open(url, '_blank', 'noopener');
      } else {
        await this.deps.navigateToUrl(url);
      }
    });
    (0, _defineProperty2.default)(this, "getRuntimeVariables", context => {
      return {
        event: (0, _event_variables.getEventScopeValues)(context),
        context: (0, _context_variables.getContextScopeValues)(context),
        ...this.deps.getGlobalScope()
      };
    });
    (0, _defineProperty2.default)(this, "getVariableList", context => {
      const globalScopeValues = this.deps.getGlobalScope();
      const eventVariables = (0, _event_variables.getEventVariableList)(context);
      const contextVariables = (0, _context_variables.getContextVariableList)(context);
      const globalVariables = (0, _global_variables.getGlobalVariableList)(globalScopeValues);
      return [...eventVariables, ...contextVariables, ...globalVariables];
    });
    (0, _defineProperty2.default)(this, "getExampleUrl", context => {
      switch (context.triggers[0]) {
        case _public.SELECT_RANGE_TRIGGER:
          return 'https://www.example.com/?from={{event.from}}&to={{event.to}}';
        case _public.CONTEXT_MENU_TRIGGER:
        case _public2.IMAGE_CLICK_TRIGGER:
          return 'https://www.example.com/?panel={{context.panel.title}}';
        case _public3.ROW_CLICK_TRIGGER:
          return 'https://www.example.com/keys={{event.keys}}&values={{event.values}}';
        case _public.VALUE_CLICK_TRIGGER:
        default:
          return 'https://www.example.com/?{{event.key}}={{event.value}}';
      }
    });
    this.deps = deps;
  }
  supportedTriggers() {
    return [_public.VALUE_CLICK_TRIGGER, _public.SELECT_RANGE_TRIGGER, _public3.ROW_CLICK_TRIGGER, _public.CONTEXT_MENU_TRIGGER, _public2.IMAGE_CLICK_TRIGGER];
  }
  async buildUrl(config, context) {
    var _config$encodeUrl;
    const doEncode = (_config$encodeUrl = config.encodeUrl) !== null && _config$encodeUrl !== void 0 ? _config$encodeUrl : true;
    const url = await (0, _public5.urlDrilldownCompileUrl)(config.url.template, this.getRuntimeVariables(context), doEncode);
    return url;
  }
}
exports.UrlDrilldown = UrlDrilldown;