"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getFixIssuesStep = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _components = require("./components");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const i18nTexts = {
  reviewStepTitle: _i18n.i18n.translate('xpack.upgradeAssistant.overview.fixIssuesStepTitle', {
    defaultMessage: 'Review deprecated settings and resolve issues'
  })
};
const FixIssuesStep = ({
  setIsComplete
}) => {
  // We consider ES and Kibana issues to be fixed when there are 0 critical issues.
  const [isEsFixed, setIsEsFixed] = (0, _react.useState)(false);
  const [isKibanaFixed, setIsKibanaFixed] = (0, _react.useState)(false);
  (0, _react.useEffect)(() => {
    setIsComplete(isEsFixed && isKibanaFixed);
    // Depending upon setIsComplete would create an infinite loop.
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [isEsFixed, isKibanaFixed]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_components.EsDeprecationIssuesPanel, {
    setIsFixed: setIsEsFixed
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_components.KibanaDeprecationIssuesPanel, {
    setIsFixed: setIsKibanaFixed
  })));
};
const getFixIssuesStep = ({
  isComplete,
  setIsComplete
}) => {
  const status = isComplete ? 'complete' : 'incomplete';
  return {
    title: i18nTexts.reviewStepTitle,
    status,
    'data-test-subj': `fixIssuesStep-${status}`,
    children: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.upgradeAssistant.overview.fixIssuesStepDescription",
      defaultMessage: "You must resolve any critical Elasticsearch and Kibana configuration issues before upgrading to the next version of the Elastic Stack. Ignoring warnings might result in differences in behavior after you upgrade."
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m"
    }), /*#__PURE__*/_react.default.createElement(FixIssuesStep, {
      setIsComplete: setIsComplete
    }))
  };
};
exports.getFixIssuesStep = getFixIssuesStep;