"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.KibanaDeprecationIssuesPanel = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _app_context = require("../../../../app_context");
var _deprecation_issues_panel = require("./deprecation_issues_panel");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const KibanaDeprecationIssuesPanel = ({
  setIsFixed
}) => {
  var _kibanaDeprecations$f, _kibanaDeprecations$f2, _kibanaDeprecations$f3, _kibanaDeprecations$f4;
  const {
    services: {
      core: {
        deprecations
      }
    }
  } = (0, _app_context.useAppContext)();
  const [kibanaDeprecations, setKibanaDeprecations] = (0, _react.useState)(undefined);
  const [isLoading, setIsLoading] = (0, _react.useState)(false);
  const [error, setError] = (0, _react.useState)(undefined);
  (0, _react.useEffect)(() => {
    async function getAllDeprecations() {
      setIsLoading(true);
      try {
        const response = await deprecations.getAllDeprecations();
        setKibanaDeprecations(response);
      } catch (e) {
        setError(e);
      }
      setIsLoading(false);
    }
    getAllDeprecations();
  }, [deprecations]);
  const criticalDeprecationsCount = (_kibanaDeprecations$f = kibanaDeprecations === null || kibanaDeprecations === void 0 ? void 0 : (_kibanaDeprecations$f2 = kibanaDeprecations.filter(deprecation => deprecation.level === 'critical')) === null || _kibanaDeprecations$f2 === void 0 ? void 0 : _kibanaDeprecations$f2.length) !== null && _kibanaDeprecations$f !== void 0 ? _kibanaDeprecations$f : 0;
  const warningDeprecationsCount = (_kibanaDeprecations$f3 = kibanaDeprecations === null || kibanaDeprecations === void 0 ? void 0 : (_kibanaDeprecations$f4 = kibanaDeprecations.filter(deprecation => deprecation.level === 'warning')) === null || _kibanaDeprecations$f4 === void 0 ? void 0 : _kibanaDeprecations$f4.length) !== null && _kibanaDeprecations$f3 !== void 0 ? _kibanaDeprecations$f3 : 0;
  const errorMessage = error && _i18n.i18n.translate('xpack.upgradeAssistant.deprecationStats.loadingErrorMessage', {
    defaultMessage: 'Could not retrieve Kibana deprecation issues.'
  });
  return /*#__PURE__*/_react.default.createElement(_deprecation_issues_panel.DeprecationIssuesPanel, {
    "data-test-subj": "kibanaStatsPanel",
    deprecationSource: "Kibana",
    linkUrl: "/kibana_deprecations",
    criticalDeprecationsCount: criticalDeprecationsCount,
    warningDeprecationsCount: warningDeprecationsCount,
    isLoading: isLoading,
    errorMessage: errorMessage,
    setIsFixed: setIsFixed
  });
};
exports.KibanaDeprecationIssuesPanel = KibanaDeprecationIssuesPanel;