"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.updateFilters = exports.removeFilter = exports.normalizeFilters = exports.moveFilter = exports.getPathInArray = exports.getGroupedFilters = exports.getFilterByPath = exports.addFilter = void 0;
var _esQuery = require("@kbn/es-query");
var _lodash = require("lodash");
var _utils = require("../../utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const PATH_SEPARATOR = '.';
const getPathInArray = path => path.split(PATH_SEPARATOR).map(Number);
exports.getPathInArray = getPathInArray;
const getGroupedFilters = filter => {
  const isCombined = (0, _esQuery.isCombinedFilter)(filter);
  if (isCombined) {
    var _filter$meta$params, _filter$meta;
    return (_filter$meta$params = filter === null || filter === void 0 ? void 0 : (_filter$meta = filter.meta) === null || _filter$meta === void 0 ? void 0 : _filter$meta.params) !== null && _filter$meta$params !== void 0 ? _filter$meta$params : [];
  } else {
    return [];
  }
};
exports.getGroupedFilters = getGroupedFilters;
const doForFilterByPath = (filters, path, action) => {
  const [first, ...restPath] = getPathInArray(path);
  const foundFilter = restPath.reduce((filter, filterLocation) => {
    return getGroupedFilters(filter)[Number(filterLocation)];
  }, filters[first]);
  return action(foundFilter);
};
const getContainerMetaByPath = (filters, pathInArray) => {
  var _getBooleanRelationTy;
  if (pathInArray.length <= 1) {
    return {
      parentFilter: undefined,
      targetArray: filters,
      parentConditionType: _esQuery.BooleanRelation.AND
    };
  }
  const parentFilter = getFilterByPath(filters, getParentFilterPath(pathInArray));
  const targetArray = getGroupedFilters(parentFilter);
  return {
    parentFilter,
    targetArray: Array.isArray(targetArray) ? targetArray : targetArray ? [targetArray] : [],
    parentConditionType: (_getBooleanRelationTy = (0, _utils.getBooleanRelationType)(parentFilter)) !== null && _getBooleanRelationTy !== void 0 ? _getBooleanRelationTy : _esQuery.BooleanRelation.AND
  };
};
const getParentFilterPath = pathInArray => pathInArray.slice(0, -1).join(PATH_SEPARATOR);
const normalizeFilters = filters => {
  const normalizeRecursively = (f, parent) => {
    if (Array.isArray(f)) {
      return normalizeArray(f, parent);
    } else if ((0, _esQuery.isCombinedFilter)(f)) {
      return normalizeCombined(f);
    }
    return f;
  };
  const normalizeArray = (filtersArray, parent) => {
    const partiallyNormalized = filtersArray.map(item => {
      const normalized = normalizeRecursively(item, filtersArray);
      if (Array.isArray(normalized)) {
        if (normalized.length === 1) {
          return normalized[0];
        }
        if (normalized.length === 0) {
          return undefined;
        }
      }
      return normalized;
    }, []).filter(Boolean);
    return Array.isArray(parent) ? partiallyNormalized.flat() : partiallyNormalized;
  };
  const normalizeCombined = combinedFilter => {
    const combinedFilters = getGroupedFilters(combinedFilter);
    const nonEmptyCombinedFilters = combinedFilters.filter(Boolean);
    if (nonEmptyCombinedFilters.length < 2) {
      return nonEmptyCombinedFilters[0];
    }
    return combinedFilter ? {
      ...combinedFilter,
      meta: {
        ...combinedFilter.meta,
        params: normalizeRecursively(nonEmptyCombinedFilters, combinedFilter)
      }
    } : undefined;
  };
  return normalizeArray(filters, filters);
};
exports.normalizeFilters = normalizeFilters;
const getFilterByPath = (filters, path) => doForFilterByPath(filters, path, f => f);
exports.getFilterByPath = getFilterByPath;
const addFilter = (filters, filter, dest, booleanRelation, dataView) => {
  var _pathInArray$at;
  const newFilters = (0, _lodash.cloneDeep)(filters);
  const pathInArray = getPathInArray(dest.path);
  const {
    targetArray,
    parentConditionType
  } = getContainerMetaByPath(newFilters, pathInArray);
  const selector = (_pathInArray$at = pathInArray.at(-1)) !== null && _pathInArray$at !== void 0 ? _pathInArray$at : 0;
  if (booleanRelation && parentConditionType !== booleanRelation) {
    targetArray.splice(selector, 1, (0, _esQuery.buildCombinedFilter)(booleanRelation, [targetArray[selector], filter], dataView));
  } else {
    targetArray.splice(dest.index, 0, filter);
  }
  return newFilters;
};
exports.addFilter = addFilter;
const removeFilterWithoutNormalization = (filters, dest) => {
  const newFilters = (0, _lodash.cloneDeep)(filters);
  const pathInArray = getPathInArray(dest.path);
  const meta = getContainerMetaByPath(newFilters, pathInArray);
  const target = meta.targetArray;
  target[dest.index] = undefined;
  return newFilters;
};
const removeFilter = (filters, dest) => {
  const newFilters = removeFilterWithoutNormalization(filters, dest);
  return normalizeFilters(newFilters);
};
exports.removeFilter = removeFilter;
const moveFilter = (filters, from, to, booleanRelation, dataView) => {
  const newFilters = (0, _lodash.cloneDeep)(filters);
  const movingFilter = getFilterByPath(newFilters, from.path);
  const filtersWithoutRemoved = removeFilterWithoutNormalization(newFilters, from);
  const updatedFilters = addFilter(filtersWithoutRemoved, movingFilter, to, booleanRelation, dataView);
  return normalizeFilters(updatedFilters);
};
exports.moveFilter = moveFilter;
const updateFilters = (filters, dest, field, operator, params) => {
  const newFilters = [...filters];
  const updatedFilter = (0, _esQuery.updateFilter)(getFilterByPath(newFilters, dest.path), field === null || field === void 0 ? void 0 : field.name, operator, params, field === null || field === void 0 ? void 0 : field.type);
  const pathInArray = getPathInArray(dest.path);
  const {
    targetArray
  } = getContainerMetaByPath(newFilters, pathInArray);
  const selector = pathInArray[pathInArray.length - 1];
  targetArray.splice(selector, 1, updatedFilter);
  return newFilters;
};
exports.updateFilters = updateFilters;