"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FieldInput = FieldInput;
exports.strings = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _reactField = require("@kbn/react-field");
var _eui = require("@elastic/eui");
var _filter_editor = require("../../filter_bar/filter_editor");
var _context = require("../context");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const DEFAULT_COMBOBOX_WIDTH = 205;
const COMBOBOX_PADDINGS = 100;
const DEFAULT_FONT = '14px Inter';
const strings = {
  getFieldSelectPlaceholderLabel: () => _i18n.i18n.translate('unifiedSearch.filter.filtersBuilder.fieldSelectPlaceholder', {
    defaultMessage: 'Select a field'
  })
};
exports.strings = strings;
function FieldInput({
  field,
  dataView,
  onHandleField
}) {
  const {
    disabled
  } = (0, _react.useContext)(_context.FiltersBuilderContextType);
  const fields = dataView ? (0, _filter_editor.getFilterableFields)(dataView) : [];
  const id = (0, _eui.useGeneratedHtmlId)({
    prefix: 'fieldInput'
  });
  const comboBoxRef = (0, _react.useRef)(null);
  const onFieldChange = (0, _react.useCallback)(([selectedField]) => {
    onHandleField(selectedField);
  }, [onHandleField]);
  const getLabel = (0, _react.useCallback)(dataViewField => ({
    label: dataViewField.customLabel || dataViewField.name,
    value: dataViewField.type
  }), []);
  const optionFields = fields.map(getLabel);
  const euiOptions = optionFields;
  const selectedEuiOptions = (field ? [field] : []).filter(option => fields.indexOf(option) !== -1).map(option => euiOptions[fields.indexOf(option)]);
  const onComboBoxChange = newOptions => {
    const newValues = newOptions.map(({
      label
    }) => fields[optionFields.findIndex(optionField => optionField.label === label)]);
    onFieldChange(newValues);
  };
  return /*#__PURE__*/_react.default.createElement("div", {
    ref: comboBoxRef
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    id: id,
    options: euiOptions,
    selectedOptions: selectedEuiOptions,
    onChange: onComboBoxChange,
    isDisabled: disabled,
    placeholder: strings.getFieldSelectPlaceholderLabel(),
    sortMatchesBy: "startsWith",
    singleSelection: {
      asPlainText: true
    },
    "aria-label": strings.getFieldSelectPlaceholderLabel(),
    isClearable: false,
    compressed: true,
    fullWidth: true,
    "data-test-subj": "filterFieldSuggestionList",
    renderOption: (option, searchValue) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "s",
      alignItems: "center",
      responsive: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: null
    }, /*#__PURE__*/_react.default.createElement(_reactField.FieldIcon, {
      type: option.value,
      fill: "none"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_filter_editor.TruncatedLabel, {
      defaultComboboxWidth: DEFAULT_COMBOBOX_WIDTH,
      defaultFont: DEFAULT_FONT,
      comboboxPaddings: COMBOBOX_PADDINGS,
      comboBoxRef: comboBoxRef,
      label: option.label,
      search: searchValue
    })))
  }));
}