"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PhrasesValuesInput = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _i18nReact = require("@kbn/i18n-react");
var _lodash = require("lodash");
var _react = _interopRequireDefault(require("react"));
var _public = require("@kbn/kibana-react-plugin/public");
var _eui = require("@elastic/eui");
var _generic_combo_box = require("./generic_combo_box");
var _phrase_suggestor = require("./phrase_suggestor");
var _truncated_label = require("./truncated_label");
var _phrases_values_input = require("./phrases_values_input.styles");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const DEFAULT_COMBOBOX_WIDTH = 250;
const COMBOBOX_PADDINGS = 20;
const DEFAULT_FONT = '14px Inter';
class PhrasesValuesInputUI extends _phrase_suggestor.PhraseSuggestorUI {
  constructor(props) {
    super(props);
    (0, _defineProperty2.default)(this, "comboBoxRef", void 0);
    this.comboBoxRef = /*#__PURE__*/_react.default.createRef();
  }
  render() {
    const {
      suggestions
    } = this.state;
    const {
      values,
      intl,
      onChange,
      fullWidth,
      onParamsUpdate,
      compressed,
      disabled
    } = this.props;
    const options = values ? (0, _lodash.uniq)([...values, ...suggestions]) : suggestions;
    return /*#__PURE__*/_react.default.createElement("div", {
      ref: this.comboBoxRef
    }, /*#__PURE__*/_react.default.createElement(StringComboBox, {
      fullWidth: fullWidth,
      compressed: compressed,
      placeholder: intl.formatMessage({
        id: 'unifiedSearch.filter.filterEditor.valuesSelectPlaceholder',
        defaultMessage: 'Select values'
      }),
      "aria-label": intl.formatMessage({
        id: 'unifiedSearch.filter.filterEditor.valuesSelectPlaceholder',
        defaultMessage: 'Select values'
      }),
      delimiter: ",",
      isCaseSensitive: true,
      options: options,
      getLabel: option => option,
      selectedOptions: values || [],
      onSearchChange: this.onSearchChange,
      onCreateOption: option => {
        onParamsUpdate(option.trim());
      },
      className: (0, _phrases_values_input.phrasesValuesComboboxCss)(this.props.theme),
      onChange: onChange,
      isClearable: false,
      "data-test-subj": "filterParamsComboBox phrasesParamsComboxBox",
      isDisabled: disabled,
      renderOption: (option, searchValue) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        gutterSize: "s",
        alignItems: "center",
        responsive: false
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_truncated_label.TruncatedLabel, {
        defaultComboboxWidth: DEFAULT_COMBOBOX_WIDTH,
        defaultFont: DEFAULT_FONT,
        comboboxPaddings: COMBOBOX_PADDINGS,
        comboBoxRef: this.comboBoxRef,
        label: option.label,
        search: searchValue
      })))
    }));
  }
}
function StringComboBox(props) {
  return (0, _generic_combo_box.GenericComboBox)(props);
}
const PhrasesValuesInput = (0, _i18nReact.injectI18n)((0, _eui.withEuiTheme)((0, _public.withKibana)(PhrasesValuesInputUI)));
exports.PhrasesValuesInput = PhrasesValuesInput;