"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.strings = exports.getFieldValidityAndErrorMessage = exports.flattenFilters = void 0;
var _lodash = require("lodash");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/data-plugin/public");
var _esQuery = require("@kbn/es-query");
var _filter_editor_utils = require("./filter_editor_utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const strings = {
  getInvalidDateFormatProvidedErrorMessage: () => _i18n.i18n.translate('unifiedSearch.filter.filterBar.invalidDateFormatProvidedErrorMessage', {
    defaultMessage: 'Invalid date format provided'
  })
};
exports.strings = strings;
const getFieldValidityAndErrorMessage = (field, value) => {
  const type = field === null || field === void 0 ? void 0 : field.type;
  switch (type) {
    case _public.KBN_FIELD_TYPES.DATE:
    case _public.KBN_FIELD_TYPES.DATE_RANGE:
      if (!(0, _lodash.isEmpty)(value) && !(0, _filter_editor_utils.validateParams)(value, field)) {
        return invalidFormatError();
      }
      break;
    default:
      break;
  }
  return noError();
};
exports.getFieldValidityAndErrorMessage = getFieldValidityAndErrorMessage;
const noError = () => {
  return {
    isInvalid: false
  };
};
const invalidFormatError = () => {
  return {
    isInvalid: true,
    errorMessage: strings.getInvalidDateFormatProvidedErrorMessage()
  };
};
const flattenFilters = filter => {
  const returnArray = [];
  const flattenFilterRecursively = f => {
    if ((0, _esQuery.isCombinedFilter)(f)) {
      f.meta.params.forEach(flattenFilterRecursively);
    } else if (f) {
      returnArray.push(f);
    }
  };
  filter.forEach(flattenFilterRecursively);
  return returnArray;
};
exports.flattenFilters = flattenFilters;