"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ChangeDataView = ChangeDataView;
exports.TextBasedLanguagesTransitionModal = exports.TextBasedLanguagesList = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _public = require("@kbn/kibana-react-plugin/public");
var _adhoc = _interopRequireDefault(require("./assets/adhoc.svg"));
var _change_dataview = require("./change_dataview.styles");
var _data_view_selector = require("./data_view_selector");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
// local storage key for the text based languages transition modal
const TEXT_LANG_TRANSITION_MODAL_KEY = 'data.textLangTransitionModal';
const Fallback = () => /*#__PURE__*/_react.default.createElement("div", null);
const LazyTextBasedLanguagesTransitionModal = /*#__PURE__*/_react.default.lazy(() => Promise.resolve().then(() => _interopRequireWildcard(require('./text_languages_transition_modal'))));
const TextBasedLanguagesTransitionModal = props => /*#__PURE__*/_react.default.createElement(_react.default.Suspense, {
  fallback: /*#__PURE__*/_react.default.createElement(Fallback, null)
}, /*#__PURE__*/_react.default.createElement(LazyTextBasedLanguagesTransitionModal, props));
exports.TextBasedLanguagesTransitionModal = TextBasedLanguagesTransitionModal;
const LazyTextBasedLanguagesList = /*#__PURE__*/_react.default.lazy(() => Promise.resolve().then(() => _interopRequireWildcard(require('./text_languages_list'))));
const TextBasedLanguagesList = props => /*#__PURE__*/_react.default.createElement(_react.default.Suspense, {
  fallback: /*#__PURE__*/_react.default.createElement(Fallback, null)
}, /*#__PURE__*/_react.default.createElement(LazyTextBasedLanguagesList, props));
exports.TextBasedLanguagesList = TextBasedLanguagesList;
const mapAdHocDataView = adHocDataView => {
  return {
    title: adHocDataView.title,
    name: adHocDataView.name,
    id: adHocDataView.id,
    isAdhoc: true
  };
};
function ChangeDataView({
  isMissingCurrent,
  currentDataViewId,
  adHocDataViews,
  savedDataViews,
  onChangeDataView,
  onAddField,
  onDataViewCreated,
  trigger,
  selectableProps,
  textBasedLanguages,
  onSaveTextLanguageQuery,
  onTextLangQuerySubmit,
  textBasedLanguage,
  isDisabled,
  onEditDataView,
  onCreateDefaultAdHocDataView
}) {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const [isPopoverOpen, setPopoverIsOpen] = (0, _react.useState)(false);
  const [dataViewsList, setDataViewsList] = (0, _react.useState)([]);
  const [triggerLabel, setTriggerLabel] = (0, _react.useState)('');
  const [isTextBasedLangSelected, setIsTextBasedLangSelected] = (0, _react.useState)(Boolean(textBasedLanguage));
  const [isTextLangTransitionModalVisible, setIsTextLangTransitionModalVisible] = (0, _react.useState)(false);
  const [selectedDataViewId, setSelectedDataViewId] = (0, _react.useState)(currentDataViewId);
  const kibana = (0, _public.useKibana)();
  const {
    application,
    data,
    storage,
    dataViews,
    dataViewEditor
  } = kibana.services;
  const styles = (0, _change_dataview.changeDataViewStyles)({
    fullWidth: trigger.fullWidth
  });
  const [isTextLangTransitionModalDismissed, setIsTextLangTransitionModalDismissed] = (0, _react.useState)(() => Boolean(storage.get(TEXT_LANG_TRANSITION_MODAL_KEY)));

  // Create a reusable id to ensure search input is the first focused item in the popover even though it's not the first item
  const searchListInputId = (0, _eui.useGeneratedHtmlId)({
    prefix: 'dataviewPickerListSearchInput'
  });
  (0, _react.useEffect)(() => {
    const fetchDataViews = async () => {
      const savedDataViewRefs = savedDataViews ? savedDataViews : await data.dataViews.getIdsWithTitle();
      // not propagate the adHoc dataviews on the list for text based languages
      const adHocDataViewRefs = !isTextBasedLangSelected && (adHocDataViews === null || adHocDataViews === void 0 ? void 0 : adHocDataViews.map(mapAdHocDataView)) || [];
      setDataViewsList(savedDataViewRefs.concat(adHocDataViewRefs));
    };
    fetchDataViews();
  }, [data, currentDataViewId, adHocDataViews, savedDataViews, isTextBasedLangSelected]);
  (0, _react.useEffect)(() => {
    if (textBasedLanguage) {
      setTriggerLabel(textBasedLanguage.toUpperCase());
    } else {
      setTriggerLabel(trigger.label);
    }
  }, [textBasedLanguage, trigger.label]);
  (0, _react.useEffect)(() => {
    if (Boolean(textBasedLanguage) !== isTextBasedLangSelected) {
      setIsTextBasedLangSelected(Boolean(textBasedLanguage));
    }
  }, [isTextBasedLangSelected, textBasedLanguage]);
  const isAdHocSelected = (0, _react.useMemo)(() => {
    return adHocDataViews === null || adHocDataViews === void 0 ? void 0 : adHocDataViews.some(dataView => dataView.id === currentDataViewId);
  }, [adHocDataViews, currentDataViewId]);
  const createTrigger = function () {
    const {
      label,
      title,
      'data-test-subj': dataTestSubj,
      fullWidth,
      ...rest
    } = trigger;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiButton, (0, _extends2.default)({
      css: styles.trigger,
      "data-test-subj": dataTestSubj,
      onClick: () => {
        setPopoverIsOpen(!isPopoverOpen);
      },
      color: isMissingCurrent ? 'danger' : 'primary',
      iconSide: "right",
      iconType: "arrowDown",
      title: triggerLabel,
      fullWidth: fullWidth,
      disabled: isDisabled,
      textProps: {
        className: 'eui-textTruncate'
      }
    }, rest), /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, isAdHocSelected && !isTextBasedLangSelected && /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: _adhoc.default,
      color: "primary",
      css: (0, _react2.css)`
                margin-right: ${euiTheme.size.s};
              `
    }), triggerLabel));
  };
  const getPanelItems = () => {
    const panelItems = [];
    if (onAddField && !isTextBasedLangSelected) {
      panelItems.push( /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
        key: "add",
        icon: "indexOpen",
        "data-test-subj": "indexPattern-add-field",
        onClick: () => {
          setPopoverIsOpen(false);
          onAddField();
        }
      }, _i18n.i18n.translate('unifiedSearch.query.queryBar.indexPattern.addFieldButton', {
        defaultMessage: 'Add a field to this data view'
      })), onEditDataView || dataViewEditor.userPermissions.editDataView() ? /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
        key: "manage",
        icon: "indexSettings",
        "data-test-subj": "indexPattern-manage-field",
        onClick: async () => {
          if (onEditDataView) {
            const dataView = await dataViews.get(currentDataViewId);
            dataViewEditor.openEditor({
              editData: dataView,
              onSave: updatedDataView => {
                onEditDataView(updatedDataView);
              }
            });
          } else {
            application.navigateToApp('management', {
              path: `/kibana/indexPatterns/patterns/${currentDataViewId}`
            });
          }
          setPopoverIsOpen(false);
        }
      }, _i18n.i18n.translate('unifiedSearch.query.queryBar.indexPattern.manageFieldButton', {
        defaultMessage: 'Manage this data view'
      })) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
        margin: "none",
        key: "dataviewActions-divider"
      }));
    }
    panelItems.push( /*#__PURE__*/_react.default.createElement(_react.default.Fragment, {
      key: "add-dataview"
    }, onDataViewCreated && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      gutterSize: "none",
      justifyContent: "spaceBetween",
      responsive: false,
      css: (0, _react2.css)`
              margin: ${euiTheme.size.s};
              margin-bottom: 0;
            `
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      gutterSize: "xs",
      responsive: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, Boolean(isTextBasedLangSelected) ? /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      position: "top",
      content: _i18n.i18n.translate('unifiedSearch.query.queryBar.indexPattern.textBasedLangSwitchWarning', {
        defaultMessage: "Switching data views removes the current SQL query. Save this search to ensure you don't lose work."
      })
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "warning",
      color: "warning",
      "data-test-subj": "textBasedLang-warning"
    })) : null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s"
    }, /*#__PURE__*/_react.default.createElement("h5", null, _i18n.i18n.translate('unifiedSearch.query.queryBar.indexPattern.dataViewsLabel', {
      defaultMessage: 'Data views'
    })))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      onClick: () => {
        setPopoverIsOpen(false);
        onDataViewCreated();
        // go to dataview mode
        if (isTextBasedLangSelected) {
          setIsTextBasedLangSelected(false);
          // clean up the Text based language query
          onTextLangQuerySubmit === null || onTextLangQuerySubmit === void 0 ? void 0 : onTextLangQuerySubmit({
            language: 'kuery',
            query: ''
          });
          setTriggerLabel(trigger.label);
        }
      },
      size: "xs",
      iconType: "plusInCircleFilled",
      iconSide: "left",
      "data-test-subj": "dataview-create-new"
    }, _i18n.i18n.translate('unifiedSearch.query.queryBar.indexPattern.addNewDataView', {
      defaultMessage: 'Create a data view'
    })))), /*#__PURE__*/_react.default.createElement(_data_view_selector.DataViewSelector, {
      currentDataViewId: currentDataViewId,
      searchListInputId: searchListInputId,
      dataViewsList: dataViewsList,
      selectableProps: selectableProps,
      isTextBasedLangSelected: isTextBasedLangSelected,
      setPopoverIsOpen: setPopoverIsOpen,
      onChangeDataView: async newId => {
        try {
          // refreshing the field list
          await dataViews.get(newId, false, true);
        } catch (e) {
          //
        }
        setSelectedDataViewId(newId);
        setPopoverIsOpen(false);
        if (isTextBasedLangSelected && !isTextLangTransitionModalDismissed) {
          setIsTextLangTransitionModalVisible(true);
        } else if (isTextBasedLangSelected && isTextLangTransitionModalDismissed) {
          setIsTextBasedLangSelected(false);
          // clean up the Text based language query
          onTextLangQuerySubmit === null || onTextLangQuerySubmit === void 0 ? void 0 : onTextLangQuerySubmit({
            language: 'kuery',
            query: ''
          });
          onChangeDataView(newId);
          setTriggerLabel(trigger.label);
        } else {
          onChangeDataView(newId);
        }
      },
      onCreateDefaultAdHocDataView: onCreateDefaultAdHocDataView
    })));
    if (textBasedLanguages !== null && textBasedLanguages !== void 0 && textBasedLanguages.length) {
      panelItems.push( /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
        margin: "none",
        key: "textbasedLanguages-divider"
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        alignItems: "center",
        gutterSize: "none",
        justifyContent: "spaceBetween",
        "data-test-subj": "select-text-based-language-panel",
        key: "text-based-languages-switcher",
        css: (0, _react2.css)`
            margin: ${euiTheme.size.s};
            margin-bottom: 0;
          `
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "s"
      }, /*#__PURE__*/_react.default.createElement("h5", null, _i18n.i18n.translate('unifiedSearch.query.queryBar.indexPattern.textBasedLanguagesLabel', {
        defaultMessage: 'Text-based query languages'
      }))))), /*#__PURE__*/_react.default.createElement(TextBasedLanguagesList, {
        key: "text-based-languages-list",
        textBasedLanguages: textBasedLanguages,
        selectedOption: triggerLabel,
        onChange: lang => {
          setTriggerLabel(lang);
          setPopoverIsOpen(false);
          setIsTextBasedLangSelected(true);
          // also update the query with the sql query
          onTextLangQuerySubmit === null || onTextLangQuerySubmit === void 0 ? void 0 : onTextLangQuerySubmit({
            sql: `SELECT * FROM "${trigger.title}"`
          });
        }
      }));
    }
    return panelItems;
  };
  let modal;
  const onTransitionModalDismiss = (0, _react.useCallback)(() => {
    storage.set(TEXT_LANG_TRANSITION_MODAL_KEY, true);
    setIsTextLangTransitionModalDismissed(true);
  }, [storage]);
  const cleanup = (0, _react.useCallback)(shouldDismissModal => {
    setIsTextLangTransitionModalVisible(false);
    setIsTextBasedLangSelected(false);
    // clean up the Text based language query
    onTextLangQuerySubmit === null || onTextLangQuerySubmit === void 0 ? void 0 : onTextLangQuerySubmit({
      language: 'kuery',
      query: ''
    });
    if (selectedDataViewId) {
      onChangeDataView(selectedDataViewId);
    }
    setTriggerLabel(trigger.label);
    if (shouldDismissModal) {
      onTransitionModalDismiss();
    }
  }, [onChangeDataView, onTextLangQuerySubmit, onTransitionModalDismiss, selectedDataViewId, trigger.label]);
  const onModalClose = (0, _react.useCallback)((shouldDismissModal, needsSave) => {
    if (Boolean(needsSave)) {
      setIsTextLangTransitionModalVisible(false);
      onSaveTextLanguageQuery === null || onSaveTextLanguageQuery === void 0 ? void 0 : onSaveTextLanguageQuery({
        onSave: () => {
          cleanup(shouldDismissModal);
        },
        onCancel: () => {
          setIsTextLangTransitionModalVisible(false);
        }
      });
    } else {
      cleanup(shouldDismissModal);
    }
  }, [cleanup, onSaveTextLanguageQuery]);
  if (isTextLangTransitionModalVisible && !isTextLangTransitionModalDismissed) {
    modal = /*#__PURE__*/_react.default.createElement(TextBasedLanguagesTransitionModal, {
      closeModal: onModalClose,
      setIsTextLangTransitionModalVisible: setIsTextLangTransitionModalVisible
    });
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    panelClassName: "changeDataViewPopover",
    button: createTrigger(),
    panelProps: {
      ['data-test-subj']: 'changeDataViewPopover'
    },
    isOpen: isPopoverOpen,
    closePopover: () => setPopoverIsOpen(false),
    panelPaddingSize: "none",
    initialFocus: !isTextBasedLangSelected ? `#${searchListInputId}` : undefined,
    display: "block",
    buffer: 8
  }, /*#__PURE__*/_react.default.createElement("div", {
    css: styles.popoverContent
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
    size: "s",
    items: getPanelItems()
  }))), modal);
}