"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UnifiedHistogramLayout = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _reactReversePortal = require("react-reverse-portal");
var _css = require("@emotion/css");
var _chart = require("../chart");
var _panels = require("../panels");
var _use_lens_suggestions = require("./hooks/use_lens_suggestions");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const UnifiedHistogramLayout = ({
  className,
  services,
  dataView,
  query,
  filters,
  currentSuggestion: originalSuggestion,
  isPlainRecord,
  timeRange,
  relativeTimeRange,
  columns,
  request,
  hits,
  chart: originalChart,
  breakdown,
  resizeRef,
  topPanelHeight,
  appendHitsCounter,
  disableAutoFetching,
  disableTriggers,
  disabledActions,
  lensSuggestionsApi,
  input$,
  onTopPanelHeightChange,
  onChartHiddenChange,
  onTimeIntervalChange,
  onBreakdownFieldChange,
  onSuggestionChange,
  onTotalHitsChange,
  onChartLoad,
  onFilter,
  onBrushEnd,
  children
}) => {
  const {
    allSuggestions,
    currentSuggestion,
    suggestionUnsupported
  } = (0, _use_lens_suggestions.useLensSuggestions)({
    dataView,
    query,
    originalSuggestion,
    isPlainRecord,
    columns,
    lensSuggestionsApi,
    onSuggestionChange
  });
  const chart = suggestionUnsupported ? undefined : originalChart;
  const topPanelNode = (0, _react.useMemo)(() => (0, _reactReversePortal.createHtmlPortalNode)({
    attributes: {
      class: 'eui-fullHeight'
    }
  }), []);
  const mainPanelNode = (0, _react.useMemo)(() => (0, _reactReversePortal.createHtmlPortalNode)({
    attributes: {
      class: 'eui-fullHeight'
    }
  }), []);
  const isMobile = (0, _eui.useIsWithinBreakpoints)(['xs', 's']);
  const showFixedPanels = isMobile || !chart || chart.hidden;
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const defaultTopPanelHeight = euiTheme.base * 12;
  const minMainPanelHeight = euiTheme.base * 10;
  const chartClassName = isMobile && chart && !chart.hidden ? (0, _css.css)`
          height: ${defaultTopPanelHeight}px;
        ` : 'eui-fullHeight';
  const panelsMode = chart || hits ? showFixedPanels ? _panels.PANELS_MODE.FIXED : _panels.PANELS_MODE.RESIZABLE : _panels.PANELS_MODE.SINGLE;
  const currentTopPanelHeight = topPanelHeight !== null && topPanelHeight !== void 0 ? topPanelHeight : defaultTopPanelHeight;
  const onResetChartHeight = (0, _react.useMemo)(() => {
    return currentTopPanelHeight !== defaultTopPanelHeight && panelsMode === _panels.PANELS_MODE.RESIZABLE ? () => onTopPanelHeightChange === null || onTopPanelHeightChange === void 0 ? void 0 : onTopPanelHeightChange(undefined) : undefined;
  }, [currentTopPanelHeight, defaultTopPanelHeight, onTopPanelHeightChange, panelsMode]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_reactReversePortal.InPortal, {
    node: topPanelNode
  }, /*#__PURE__*/_react.default.createElement(_chart.Chart, {
    className: chartClassName,
    services: services,
    dataView: dataView,
    query: query,
    filters: filters,
    timeRange: timeRange,
    relativeTimeRange: relativeTimeRange,
    request: request,
    hits: hits,
    currentSuggestion: currentSuggestion,
    allSuggestions: allSuggestions,
    isPlainRecord: isPlainRecord,
    chart: chart,
    breakdown: breakdown,
    appendHitsCounter: appendHitsCounter,
    appendHistogram: showFixedPanels ? /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    }) : /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "l"
    }),
    disableAutoFetching: disableAutoFetching,
    disableTriggers: disableTriggers,
    disabledActions: disabledActions,
    input$: input$,
    onResetChartHeight: onResetChartHeight,
    onChartHiddenChange: onChartHiddenChange,
    onTimeIntervalChange: onTimeIntervalChange,
    onBreakdownFieldChange: onBreakdownFieldChange,
    onSuggestionChange: onSuggestionChange,
    onTotalHitsChange: onTotalHitsChange,
    onChartLoad: onChartLoad,
    onFilter: onFilter,
    onBrushEnd: onBrushEnd
  })), /*#__PURE__*/_react.default.createElement(_reactReversePortal.InPortal, {
    node: mainPanelNode
  }, children), /*#__PURE__*/_react.default.createElement(_panels.Panels, {
    className: className,
    mode: panelsMode,
    resizeRef: resizeRef,
    topPanelHeight: currentTopPanelHeight,
    minTopPanelHeight: defaultTopPanelHeight,
    minMainPanelHeight: minMainPanelHeight,
    topPanel: /*#__PURE__*/_react.default.createElement(_reactReversePortal.OutPortal, {
      node: topPanelNode
    }),
    mainPanel: /*#__PURE__*/_react.default.createElement(_reactReversePortal.OutPortal, {
      node: mainPanelNode
    }),
    onTopPanelHeightChange: onTopPanelHeightChange
  }));
};
exports.UnifiedHistogramLayout = UnifiedHistogramLayout;