"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useLensSuggestions = void 0;
var _esQuery = require("@kbn/es-query");
var _lodash = require("lodash");
var _react = require("react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const useLensSuggestions = ({
  dataView,
  query,
  originalSuggestion,
  isPlainRecord,
  columns,
  lensSuggestionsApi,
  onSuggestionChange
}) => {
  const suggestions = (0, _react.useMemo)(() => {
    var _lensSuggestionsApi;
    const context = {
      dataViewSpec: dataView === null || dataView === void 0 ? void 0 : dataView.toSpec(),
      fieldName: '',
      contextualFields: columns,
      query: query && (0, _esQuery.isOfAggregateQueryType)(query) ? query : undefined
    };
    const allSuggestions = isPlainRecord ? (_lensSuggestionsApi = lensSuggestionsApi(context, dataView, ['lnsDatatable'])) !== null && _lensSuggestionsApi !== void 0 ? _lensSuggestionsApi : [] : [];
    const [firstSuggestion] = allSuggestions;
    return {
      firstSuggestion,
      allSuggestions
    };
  }, [columns, dataView, isPlainRecord, lensSuggestionsApi, query]);
  const [allSuggestions, setAllSuggestions] = (0, _react.useState)(suggestions.allSuggestions);
  const currentSuggestion = originalSuggestion !== null && originalSuggestion !== void 0 ? originalSuggestion : suggestions.firstSuggestion;
  const suggestionDeps = (0, _react.useRef)(getSuggestionDeps({
    dataView,
    query,
    columns
  }));
  (0, _react.useEffect)(() => {
    const newSuggestionsDeps = getSuggestionDeps({
      dataView,
      query,
      columns
    });
    if (!(0, _lodash.isEqual)(suggestionDeps.current, newSuggestionsDeps)) {
      setAllSuggestions(suggestions.allSuggestions);
      onSuggestionChange === null || onSuggestionChange === void 0 ? void 0 : onSuggestionChange(suggestions.firstSuggestion);
      suggestionDeps.current = newSuggestionsDeps;
    }
  }, [columns, dataView, onSuggestionChange, query, suggestions.firstSuggestion, suggestions.allSuggestions]);
  return {
    allSuggestions,
    currentSuggestion,
    suggestionUnsupported: isPlainRecord && !currentSuggestion
  };
};
exports.useLensSuggestions = useLensSuggestions;
const getSuggestionDeps = ({
  dataView,
  query,
  columns
}) => [dataView.id, columns, query];