"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Chart = Chart;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/data-views-plugin/public");
var _rxjs = require("rxjs");
var _hits_counter = require("../hits_counter");
var _histogram = require("./histogram");
var _use_chart_panels = require("./hooks/use_chart_panels");
var _breakdown_field_selector = require("./breakdown_field_selector");
var _suggestion_selector = require("./suggestion_selector");
var _use_total_hits = require("./hooks/use_total_hits");
var _use_request_params = require("./hooks/use_request_params");
var _use_chart_styles = require("./hooks/use_chart_styles");
var _use_chart_actions = require("./hooks/use_chart_actions");
var _get_lens_attributes = require("./utils/get_lens_attributes");
var _use_refetch = require("./hooks/use_refetch");
var _use_edit_visualization = require("./hooks/use_edit_visualization");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const HistogramMemoized = /*#__PURE__*/(0, _react.memo)(_histogram.Histogram);
function Chart({
  className,
  services,
  dataView,
  query: originalQuery,
  filters: originalFilters,
  timeRange: originalTimeRange,
  relativeTimeRange: originalRelativeTimeRange,
  request,
  hits,
  chart,
  breakdown,
  currentSuggestion,
  allSuggestions,
  isPlainRecord,
  appendHitsCounter,
  appendHistogram,
  disableAutoFetching,
  disableTriggers,
  disabledActions,
  input$: originalInput$,
  onResetChartHeight,
  onChartHiddenChange,
  onTimeIntervalChange,
  onSuggestionChange,
  onBreakdownFieldChange,
  onTotalHitsChange,
  onChartLoad,
  onFilter,
  onBrushEnd
}) {
  var _services$capabilitie;
  const [isSaveModalVisible, setIsSaveModalVisible] = (0, _react.useState)(false);
  const {
    showChartOptionsPopover,
    chartRef,
    toggleChartOptions,
    closeChartOptions,
    toggleHideChart
  } = (0, _use_chart_actions.useChartActions)({
    chart,
    onChartHiddenChange
  });
  const panels = (0, _use_chart_panels.useChartPanels)({
    chart,
    toggleHideChart,
    onTimeIntervalChange,
    closePopover: closeChartOptions,
    onResetChartHeight,
    isPlainRecord
  });
  const chartVisible = !!(chart && !chart.hidden && dataView.id && dataView.type !== _public.DataViewType.ROLLUP && (isPlainRecord || !isPlainRecord && dataView.isTimeBased()));
  const input$ = (0, _react.useMemo)(() => originalInput$ !== null && originalInput$ !== void 0 ? originalInput$ : new _rxjs.Subject(), [originalInput$]);
  const {
    filters,
    query,
    getTimeRange,
    updateTimeRange,
    relativeTimeRange
  } = (0, _use_request_params.useRequestParams)({
    services,
    query: originalQuery,
    filters: originalFilters,
    timeRange: originalTimeRange
  });
  const refetch$ = (0, _use_refetch.useRefetch)({
    dataView,
    request,
    hits,
    chart,
    chartVisible,
    breakdown,
    filters,
    query,
    relativeTimeRange,
    currentSuggestion,
    disableAutoFetching,
    input$,
    beforeRefetch: updateTimeRange
  });
  (0, _use_total_hits.useTotalHits)({
    services,
    dataView,
    request,
    hits,
    chartVisible,
    filters,
    query,
    getTimeRange,
    refetch$,
    onTotalHitsChange,
    isPlainRecord
  });
  const {
    resultCountCss,
    resultCountInnerCss,
    resultCountTitleCss,
    resultCountToggleCss,
    histogramCss,
    breakdownFieldSelectorGroupCss,
    breakdownFieldSelectorItemCss,
    chartToolButtonCss
  } = (0, _use_chart_styles.useChartStyles)(chartVisible);
  const lensAttributesContext = (0, _react.useMemo)(() => (0, _get_lens_attributes.getLensAttributes)({
    title: chart === null || chart === void 0 ? void 0 : chart.title,
    filters,
    query,
    dataView,
    timeInterval: chart === null || chart === void 0 ? void 0 : chart.timeInterval,
    breakdownField: breakdown === null || breakdown === void 0 ? void 0 : breakdown.field,
    suggestion: currentSuggestion
  }), [breakdown === null || breakdown === void 0 ? void 0 : breakdown.field, chart === null || chart === void 0 ? void 0 : chart.timeInterval, chart === null || chart === void 0 ? void 0 : chart.title, currentSuggestion, dataView, filters, query]);
  const onEditVisualization = (0, _use_edit_visualization.useEditVisualization)({
    services,
    dataView,
    relativeTimeRange: originalRelativeTimeRange !== null && originalRelativeTimeRange !== void 0 ? originalRelativeTimeRange : relativeTimeRange,
    lensAttributes: lensAttributesContext.attributes,
    isPlainRecord
  });
  const LensSaveModalComponent = services.lens.SaveModalComponent;
  const canSaveVisualization = chartVisible && currentSuggestion && ((_services$capabilitie = services.capabilities.dashboard) === null || _services$capabilitie === void 0 ? void 0 : _services$capabilitie.showWriteControls);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    className: className,
    direction: "column",
    alignItems: "stretch",
    gutterSize: "none",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    css: resultCountCss
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    gutterSize: "none",
    responsive: false,
    css: resultCountInnerCss
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    className: "eui-textTruncate eui-textNoWrap",
    css: resultCountTitleCss
  }, hits && /*#__PURE__*/_react.default.createElement(_hits_counter.HitsCounter, {
    hits: hits,
    append: appendHitsCounter
  })), chart && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    css: resultCountToggleCss
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "none",
    responsive: false,
    justifyContent: "flexEnd",
    css: breakdownFieldSelectorGroupCss
  }, chartVisible && breakdown && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    css: breakdownFieldSelectorItemCss
  }, /*#__PURE__*/_react.default.createElement(_breakdown_field_selector.BreakdownFieldSelector, {
    dataView: dataView,
    breakdown: breakdown,
    onBreakdownFieldChange: onBreakdownFieldChange
  })), chartVisible && currentSuggestion && allSuggestions && (allSuggestions === null || allSuggestions === void 0 ? void 0 : allSuggestions.length) > 1 && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    css: breakdownFieldSelectorItemCss
  }, /*#__PURE__*/_react.default.createElement(_suggestion_selector.SuggestionSelector, {
    suggestions: allSuggestions,
    activeSuggestion: currentSuggestion,
    onSuggestionChange: onSuggestionChange
  })), canSaveVisualization && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    css: chartToolButtonCss
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: _i18n.i18n.translate('unifiedHistogram.saveVisualizationButton', {
      defaultMessage: 'Save visualization'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    size: "xs",
    iconType: "save",
    onClick: () => setIsSaveModalVisible(true),
    "data-test-subj": "unifiedHistogramSaveVisualization",
    "aria-label": _i18n.i18n.translate('unifiedHistogram.saveVisualizationButton', {
      defaultMessage: 'Save visualization'
    })
  })))), onEditVisualization && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    css: chartToolButtonCss
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: _i18n.i18n.translate('unifiedHistogram.editVisualizationButton', {
      defaultMessage: 'Edit visualization'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    size: "xs",
    iconType: "lensApp",
    onClick: onEditVisualization,
    "data-test-subj": "unifiedHistogramEditVisualization",
    "aria-label": _i18n.i18n.translate('unifiedHistogram.editVisualizationButton', {
      defaultMessage: 'Edit visualization'
    })
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    css: chartToolButtonCss
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    id: "unifiedHistogramChartOptions",
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: _i18n.i18n.translate('unifiedHistogram.chartOptionsButton', {
        defaultMessage: 'Chart options'
      })
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      size: "xs",
      iconType: "gear",
      onClick: toggleChartOptions,
      "data-test-subj": "unifiedHistogramChartOptionsToggle",
      "aria-label": _i18n.i18n.translate('unifiedHistogram.chartOptionsButton', {
        defaultMessage: 'Chart options'
      })
    })),
    isOpen: showChartOptionsPopover,
    closePopover: closeChartOptions,
    panelPaddingSize: "none",
    anchorPosition: "downLeft"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenu, {
    initialPanelId: 0,
    panels: panels
  }))))))), chartVisible && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement("section", {
    ref: element => chartRef.current.element = element,
    tabIndex: -1,
    "aria-label": _i18n.i18n.translate('unifiedHistogram.histogramOfFoundDocumentsAriaLabel', {
      defaultMessage: 'Histogram of found documents'
    }),
    css: histogramCss
  }, /*#__PURE__*/_react.default.createElement(HistogramMemoized, {
    services: services,
    dataView: dataView,
    request: request,
    hits: hits,
    chart: chart,
    getTimeRange: getTimeRange,
    refetch$: refetch$,
    lensAttributesContext: lensAttributesContext,
    isPlainRecord: isPlainRecord,
    disableTriggers: disableTriggers,
    disabledActions: disabledActions,
    onTotalHitsChange: onTotalHitsChange,
    onChartLoad: onChartLoad,
    onFilter: onFilter,
    onBrushEnd: onBrushEnd
  })), appendHistogram), canSaveVisualization && isSaveModalVisible && lensAttributesContext.attributes && /*#__PURE__*/_react.default.createElement(LensSaveModalComponent, {
    initialInput: lensAttributesContext.attributes,
    onSave: () => {},
    onClose: () => setIsSaveModalVisible(false),
    isSaveable: false
  }));
}