"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UNKNOWN_FIELD_TYPE_DESC = void 0;
exports.getFieldTypeDescription = getFieldTypeDescription;
var _i18n = require("@kbn/i18n");
var _fieldTypes = require("@kbn/field-types");
var _field_types = require("./field_types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * A user-friendly description of an unknown field type
 */
const UNKNOWN_FIELD_TYPE_DESC = _i18n.i18n.translate('unifiedFieldList.fieldNameDescription.unknownField', {
  defaultMessage: 'Unknown field'
});

/**
 * Returns a user-friendly description of a field type
 * @param type
 * @public
 */
exports.UNKNOWN_FIELD_TYPE_DESC = UNKNOWN_FIELD_TYPE_DESC;
function getFieldTypeDescription(type) {
  if (!type || type === _fieldTypes.KBN_FIELD_TYPES.UNKNOWN) {
    return UNKNOWN_FIELD_TYPE_DESC;
  }
  const knownType = type;
  switch (knownType) {
    case _field_types.KNOWN_FIELD_TYPES.DOCUMENT:
      return _i18n.i18n.translate('unifiedFieldList.fieldNameDescription.recordField', {
        defaultMessage: 'Count of records.'
      });
    case _field_types.KNOWN_FIELD_TYPES.BINARY:
      return _i18n.i18n.translate('unifiedFieldList.fieldNameDescription.binaryField', {
        defaultMessage: 'Binary value encoded as a Base64 string.'
      });
    case _field_types.KNOWN_FIELD_TYPES.BOOLEAN:
      return _i18n.i18n.translate('unifiedFieldList.fieldNameDescription.booleanField', {
        defaultMessage: 'True and false values.'
      });
    case _field_types.KNOWN_FIELD_TYPES.CONFLICT:
      return _i18n.i18n.translate('unifiedFieldList.fieldNameDescription.conflictField', {
        defaultMessage: 'Field has values of different types. Resolve in Management > Data Views.'
      });
    case _field_types.KNOWN_FIELD_TYPES.COUNTER:
      return _i18n.i18n.translate('unifiedFieldList.fieldNameDescription.counterField', {
        defaultMessage: 'A number that only increases or resets to 0 (zero). Available only for numeric and aggregate_metric_double fields.'
      });
    case _field_types.KNOWN_FIELD_TYPES.DATE:
      return _i18n.i18n.translate('unifiedFieldList.fieldNameDescription.dateField', {
        defaultMessage: 'A date string or the number of seconds or milliseconds since 1/1/1970.'
      });
    case _field_types.KNOWN_FIELD_TYPES.DATE_RANGE:
      return _i18n.i18n.translate('unifiedFieldList.fieldNameDescription.dateRangeField', {
        defaultMessage: 'Range of date values.'
      });
    case _field_types.KNOWN_FIELD_TYPES.DENSE_VECTOR:
      return _i18n.i18n.translate('unifiedFieldList.fieldNameDescription.denseVectorField', {
        defaultMessage: 'Records dense vectors of float values.'
      });
    case _field_types.KNOWN_FIELD_TYPES.GAUGE:
      return _i18n.i18n.translate('unifiedFieldList.fieldNameDescription.gaugeField', {
        defaultMessage: 'A number that can increase or decrease. Available only for numeric and aggregate_metric_double fields.'
      });
    case _field_types.KNOWN_FIELD_TYPES.GEO_POINT:
      return _i18n.i18n.translate('unifiedFieldList.fieldNameDescription.geoPointField', {
        defaultMessage: 'Latitude and longitude points.'
      });
    case _field_types.KNOWN_FIELD_TYPES.GEO_SHAPE:
      return _i18n.i18n.translate('unifiedFieldList.fieldNameDescription.geoShapeField', {
        defaultMessage: 'Complex shapes, such as polygons.'
      });
    case _field_types.KNOWN_FIELD_TYPES.HISTOGRAM:
      return _i18n.i18n.translate('unifiedFieldList.fieldNameDescription.histogramField', {
        defaultMessage: 'Pre-aggregated numerical values in the form of a histogram.'
      });
    case _field_types.KNOWN_FIELD_TYPES.IP:
      return _i18n.i18n.translate('unifiedFieldList.fieldNameDescription.ipAddressField', {
        defaultMessage: 'IPv4 and IPv6 addresses.'
      });
    case _field_types.KNOWN_FIELD_TYPES.IP_RANGE:
      return _i18n.i18n.translate('unifiedFieldList.fieldNameDescription.ipAddressRangeField', {
        defaultMessage: 'Range of ip values supporting either IPv4 or IPv6 (or mixed) addresses.'
      });
    case _field_types.KNOWN_FIELD_TYPES.FLATTENED:
      return _i18n.i18n.translate('unifiedFieldList.fieldNameDescription.flattenedField', {
        defaultMessage: 'An entire JSON object as a single field value.'
      });
    case _field_types.KNOWN_FIELD_TYPES.MURMUR3:
      return _i18n.i18n.translate('unifiedFieldList.fieldNameDescription.murmur3Field', {
        defaultMessage: 'Field that computes and stores hashes of values.'
      });
    case _field_types.KNOWN_FIELD_TYPES.NUMBER:
      return _i18n.i18n.translate('unifiedFieldList.fieldNameDescription.numberField', {
        defaultMessage: 'Long, integer, short, byte, double, and float values.'
      });
    case _field_types.KNOWN_FIELD_TYPES.RANK_FEATURE:
      return _i18n.i18n.translate('unifiedFieldList.fieldNameDescription.rankFeatureField', {
        defaultMessage: 'Records a numeric feature to boost hits at query time.'
      });
    case _field_types.KNOWN_FIELD_TYPES.RANK_FEATURES:
      return _i18n.i18n.translate('unifiedFieldList.fieldNameDescription.rankFeaturesField', {
        defaultMessage: 'Records numeric features to boost hits at query time.'
      });
    case _field_types.KNOWN_FIELD_TYPES.POINT:
      return _i18n.i18n.translate('unifiedFieldList.fieldNameDescription.pointField', {
        defaultMessage: 'Arbitrary cartesian points.'
      });
    case _field_types.KNOWN_FIELD_TYPES.SHAPE:
      return _i18n.i18n.translate('unifiedFieldList.fieldNameDescription.shapeField', {
        defaultMessage: 'Arbitrary cartesian geometries.'
      });
    case _field_types.KNOWN_FIELD_TYPES.STRING:
      return _i18n.i18n.translate('unifiedFieldList.fieldNameDescription.stringField', {
        defaultMessage: 'Full text such as the body of an email or a product description.'
      });
    case _field_types.KNOWN_FIELD_TYPES.TEXT:
      return _i18n.i18n.translate('unifiedFieldList.fieldNameDescription.textField', {
        defaultMessage: 'Full text such as the body of an email or a product description.'
      });
    case _field_types.KNOWN_FIELD_TYPES.KEYWORD:
      return _i18n.i18n.translate('unifiedFieldList.fieldNameDescription.keywordField', {
        defaultMessage: 'Structured content such as an ID, email address, hostname, status code, or tag.'
      });
    case _field_types.KNOWN_FIELD_TYPES.NESTED:
      return _i18n.i18n.translate('unifiedFieldList.fieldNameDescription.nestedField', {
        defaultMessage: 'JSON object that preserves the relationship between its subfields.'
      });
    case _field_types.KNOWN_FIELD_TYPES.VERSION:
      return _i18n.i18n.translate('unifiedFieldList.fieldNameDescription.versionField', {
        defaultMessage: 'Software versions. Supports "Semantic Versioning" precedence rules.'
      });
    default:
      // If you see a typescript error here, that's a sign that there are missing switch cases ^^
      const _exhaustiveCheck = knownType;
      return knownType || _exhaustiveCheck;
  }
}