"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _common = require("@kbn/data-plugin/common");
var _datemath = _interopRequireDefault(require("@kbn/datemath"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _charts = require("@elastic/charts");
var _i18n = require("@kbn/i18n");
var _esQuery = require("@kbn/es-query");
var _field_examples_calculator = require("../../services/field_stats/field_examples_calculator");
var _field_stats_utils = require("../../services/field_stats/field_stats_utils");
var _field_stats = require("../../services/field_stats");
var _field_top_values = require("./field_top_values");
var _field_summary_message = require("./field_summary_message");
var _field_number_summary = require("./field_number_summary");
var _error_boundary = require("../error_boundary");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const FieldStatsComponent = ({
  services,
  query,
  dslQuery,
  filters,
  fromDate,
  toDate,
  dataViewOrDataViewId,
  field,
  color = (0, _field_top_values.getDefaultColor)(),
  'data-test-subj': dataTestSubject = 'fieldStats',
  overrideMissingContent,
  overrideFooter,
  onAddFilter,
  overrideFieldTopValueBar,
  onStateChange
}) => {
  const {
    fieldFormats,
    uiSettings,
    charts,
    dataViews,
    data
  } = services;
  const [state, changeState] = (0, _react.useState)({
    isLoading: false
  });
  const [dataView, changeDataView] = (0, _react.useState)(null);
  const abortControllerRef = (0, _react.useRef)(null);
  const isCanceledRef = (0, _react.useRef)(false);
  const setState = (0, _react.useCallback)(nextState => {
    if (!isCanceledRef.current) {
      changeState(nextState);
    }
  }, [changeState, isCanceledRef]);
  (0, _react.useEffect)(function broadcastOnStateChange() {
    if (onStateChange) {
      onStateChange(state);
    }
  }, [onStateChange, state]);
  const setDataView = (0, _react.useCallback)(nextDataView => {
    if (!isCanceledRef.current) {
      changeDataView(nextDataView);
    }
  }, [changeDataView, isCanceledRef]);
  async function fetchData() {
    if (isCanceledRef.current) {
      return;
    }
    try {
      var _abortControllerRef$c;
      const loadedDataView = typeof dataViewOrDataViewId === 'string' ? await dataViews.get(dataViewOrDataViewId) : dataViewOrDataViewId;
      setDataView(loadedDataView);
      if (state.isLoading) {
        return;
      }
      setState(s => ({
        ...s,
        isLoading: true
      }));
      (_abortControllerRef$c = abortControllerRef.current) === null || _abortControllerRef$c === void 0 ? void 0 : _abortControllerRef$c.abort();
      abortControllerRef.current = new AbortController();
      const results = await (0, _field_stats.loadFieldStats)({
        services: {
          data
        },
        dataView: loadedDataView,
        field,
        fromDate,
        toDate,
        dslQuery: dslQuery !== null && dslQuery !== void 0 ? dslQuery : (0, _esQuery.buildEsQuery)(loadedDataView, query !== null && query !== void 0 ? query : [], filters !== null && filters !== void 0 ? filters : [], (0, _common.getEsQueryConfig)(uiSettings)),
        abortController: abortControllerRef.current
      });
      abortControllerRef.current = null;
      setState(s => ({
        ...s,
        isLoading: false,
        totalDocuments: results.totalDocuments,
        sampledDocuments: results.sampledDocuments,
        sampledValues: results.sampledValues,
        histogram: results.histogram,
        topValues: results.topValues,
        numberSummary: results.numberSummary
      }));
    } catch (e) {
      setState(s => ({
        ...s,
        isLoading: false
      }));
    }
  }
  (0, _react.useEffect)(() => {
    fetchData();
  }, [dataViewOrDataViewId, field, dslQuery, query, filters, fromDate, toDate, services]); // eslint-disable-line react-hooks/exhaustive-deps

  (0, _react.useEffect)(() => {
    return () => {
      var _abortControllerRef$c2;
      isCanceledRef.current = true;
      (_abortControllerRef$c2 = abortControllerRef.current) === null || _abortControllerRef$c2 === void 0 ? void 0 : _abortControllerRef$c2.abort();
    };
  }, []);
  const chartTheme = charts.theme.useChartsTheme();
  const chartBaseTheme = charts.theme.useChartsBaseTheme();
  const customChartTheme = (0, _react.useMemo)(() => {
    var _chartTheme$barSeries;
    return color ? {
      ...chartTheme,
      barSeriesStyle: {
        ...chartTheme.barSeriesStyle,
        rect: {
          ...(((_chartTheme$barSeries = chartTheme.barSeriesStyle) === null || _chartTheme$barSeries === void 0 ? void 0 : _chartTheme$barSeries.rect) || {}),
          fill: color
        }
      }
    } : chartTheme;
  }, [chartTheme, color]);
  const {
    isLoading,
    histogram,
    topValues,
    numberSummary,
    sampledValues,
    sampledDocuments,
    totalDocuments
  } = state;
  let histogramDefault = !!state.histogram;
  const fromDateParsed = _datemath.default.parse(fromDate);
  const toDateParsed = _datemath.default.parse(toDate);
  const bucketsValuesCount = (0, _field_top_values.getBucketsValuesCount)(topValues === null || topValues === void 0 ? void 0 : topValues.buckets);
  const otherCount = (0, _field_top_values.getOtherCount)(bucketsValuesCount, sampledValues);
  if (bucketsValuesCount && histogram && histogram.buckets.length && topValues && topValues.buckets.length) {
    // Default to histogram when top values are less than 10% of total
    histogramDefault = otherCount / bucketsValuesCount > 0.9;
  }
  const [showingHistogram, setShowingHistogram] = (0, _react.useState)(histogramDefault);
  if (isLoading) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, null);
  }
  if (!dataView) {
    return null;
  }
  const formatter = dataView.getFormatterForField(field);
  let title = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null);
  function combineWithTitleAndFooter(el) {
    const dataTestSubjDocsCount = 'unifiedFieldStats-statsFooter-docsCount';
    const countsElement = totalDocuments ? /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      color: "subdued",
      size: "xs",
      "data-test-subj": `${dataTestSubject}-statsFooter`
    }, sampledDocuments && sampledDocuments < totalDocuments ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "unifiedFieldList.fieldStats.calculatedFromSampleRecordsLabel",
      defaultMessage: "Calculated from {sampledDocumentsFormatted} sample {sampledDocuments, plural, one {record} other {records}}.",
      values: {
        sampledDocuments,
        sampledDocumentsFormatted: /*#__PURE__*/_react.default.createElement("strong", {
          "data-test-subj": dataTestSubjDocsCount
        }, fieldFormats.getDefaultInstance(_common.KBN_FIELD_TYPES.NUMBER, [_common.ES_FIELD_TYPES.INTEGER]).convert(sampledDocuments))
      }
    }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "unifiedFieldList.fieldStats.calculatedFromTotalRecordsLabel",
      defaultMessage: "Calculated from {totalDocumentsFormatted} {totalDocuments, plural, one {record} other {records}}.",
      values: {
        totalDocuments,
        totalDocumentsFormatted: /*#__PURE__*/_react.default.createElement("strong", {
          "data-test-subj": dataTestSubjDocsCount
        }, fieldFormats.getDefaultInstance(_common.KBN_FIELD_TYPES.NUMBER, [_common.ES_FIELD_TYPES.INTEGER]).convert(totalDocuments))
      }
    })) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null);
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, title ? /*#__PURE__*/_react.default.createElement("div", {
      "data-test-subj": `${dataTestSubject}-title`
    }, title) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    }), el, overrideFooter ? overrideFooter === null || overrideFooter === void 0 ? void 0 : overrideFooter({
      element: countsElement,
      totalDocuments,
      sampledDocuments
    }) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m"
    }), countsElement));
  }
  if (!(0, _field_stats_utils.canProvideStatsForField)(field)) {
    const messageNoAnalysis = /*#__PURE__*/_react.default.createElement(_field_summary_message.FieldSummaryMessage, {
      message: _i18n.i18n.translate('unifiedFieldList.fieldStats.notAvailableForThisFieldDescription', {
        defaultMessage: 'Analysis is not available for this field.'
      })
    });
    return overrideMissingContent ? overrideMissingContent({
      reason: 'unsupported',
      element: messageNoAnalysis
    }) : messageNoAnalysis;
  }
  if ((0, _field_stats_utils.canProvideNumberSummaryForField)(field) && (0, _field_number_summary.isNumberSummaryValid)(numberSummary)) {
    title = /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xxxs"
    }, /*#__PURE__*/_react.default.createElement("h6", null, _i18n.i18n.translate('unifiedFieldList.fieldStats.numberSummary.summaryTableTitle', {
      defaultMessage: 'Summary'
    })));
    return combineWithTitleAndFooter( /*#__PURE__*/_react.default.createElement(_field_number_summary.FieldNumberSummary, {
      dataView: dataView,
      field: field,
      numberSummary: numberSummary,
      "data-test-subj": dataTestSubject
    }));
  }
  if ((!histogram || histogram.buckets.length === 0) && (!topValues || topValues.buckets.length === 0)) {
    const messageNoData = sampledDocuments && totalDocuments && sampledDocuments < totalDocuments ? /*#__PURE__*/_react.default.createElement(_field_summary_message.FieldSummaryMessage, {
      message: _i18n.i18n.translate('unifiedFieldList.fieldStats.noFieldDataInSampleDescription', {
        defaultMessage: 'No field data for {sampledDocumentsFormatted} sample {sampledDocuments, plural, one {record} other {records}}.',
        values: {
          sampledDocuments,
          sampledDocumentsFormatted: fieldFormats.getDefaultInstance(_common.KBN_FIELD_TYPES.NUMBER, [_common.ES_FIELD_TYPES.INTEGER]).convert(sampledDocuments)
        }
      })
    }) : /*#__PURE__*/_react.default.createElement(_field_summary_message.FieldSummaryMessage, {
      message: _i18n.i18n.translate('unifiedFieldList.fieldStats.noFieldDataDescription', {
        defaultMessage: 'No field data for the current search.'
      })
    });
    return overrideMissingContent ? overrideMissingContent({
      reason: 'no-data',
      element: messageNoData
    }) : messageNoData;
  }
  if (histogram && histogram.buckets.length && topValues && topValues.buckets.length) {
    title = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, {
      "data-test-subj": "unifiedFieldStats-buttonGroup",
      buttonSize: "compressed",
      isFullWidth: true,
      legend: _i18n.i18n.translate('unifiedFieldList.fieldStats.displayToggleLegend', {
        defaultMessage: 'Toggle either the'
      }),
      options: [{
        label: _i18n.i18n.translate('unifiedFieldList.fieldStats.topValuesLabel', {
          defaultMessage: 'Top values'
        }),
        id: 'topValues',
        'data-test-subj': `${dataTestSubject}-buttonGroup-topValuesButton`
      }, {
        label: _i18n.i18n.translate('unifiedFieldList.fieldStats.fieldDistributionLabel', {
          defaultMessage: 'Distribution'
        }),
        id: 'histogram',
        'data-test-subj': `${dataTestSubject}-buttonGroup-distributionButton`
      }],
      onChange: optionId => {
        setShowingHistogram(optionId === 'histogram');
      },
      idSelected: showingHistogram ? 'histogram' : 'topValues'
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "xs"
    }));
  } else if (field.type === 'date') {
    title = /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xxxs"
    }, /*#__PURE__*/_react.default.createElement("h6", null, _i18n.i18n.translate('unifiedFieldList.fieldStats.fieldTimeDistributionLabel', {
      defaultMessage: 'Time distribution'
    })));
  } else if (topValues && topValues.buckets.length) {
    title = /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xxxs"
    }, /*#__PURE__*/_react.default.createElement("h6", null, (0, _field_examples_calculator.showExamplesForField)(field) ? _i18n.i18n.translate('unifiedFieldList.fieldStats.examplesLabel', {
      defaultMessage: 'Examples'
    }) : _i18n.i18n.translate('unifiedFieldList.fieldStats.topValuesLabel', {
      defaultMessage: 'Top values'
    })));
  }
  if (histogram && histogram.buckets.length) {
    const specId = _i18n.i18n.translate('unifiedFieldList.fieldStats.countLabel', {
      defaultMessage: 'Count'
    });
    if (field.type === 'date') {
      return combineWithTitleAndFooter( /*#__PURE__*/_react.default.createElement("div", {
        "data-test-subj": "unifiedFieldStats-timeDistribution"
      }, /*#__PURE__*/_react.default.createElement("div", {
        "data-test-subj": `${dataTestSubject}-histogram`
      }, /*#__PURE__*/_react.default.createElement(_charts.Chart, {
        size: {
          height: 200,
          width: 300 - 32
        }
      }, /*#__PURE__*/_react.default.createElement(_charts.Tooltip, {
        type: _charts.TooltipType.None
      }), /*#__PURE__*/_react.default.createElement(_charts.Settings, {
        theme: customChartTheme,
        baseTheme: chartBaseTheme,
        xDomain: fromDateParsed && toDateParsed ? {
          min: fromDateParsed.valueOf(),
          max: toDateParsed.valueOf(),
          minInterval: Math.round((toDateParsed.valueOf() - fromDateParsed.valueOf()) / 10)
        } : undefined
      }), /*#__PURE__*/_react.default.createElement(_charts.Axis, {
        id: "key",
        position: _charts.Position.Bottom,
        tickFormat: fromDateParsed && toDateParsed ? (0, _charts.niceTimeFormatter)([fromDateParsed.valueOf(), toDateParsed.valueOf()]) : undefined,
        showOverlappingTicks: true
      }), /*#__PURE__*/_react.default.createElement(_charts.HistogramBarSeries, {
        data: histogram.buckets,
        id: specId,
        xAccessor: 'key',
        yAccessors: ['count'],
        xScaleType: _charts.ScaleType.Time,
        yScaleType: _charts.ScaleType.Linear,
        timeZone: "local"
      })))));
    }
    if (showingHistogram || !topValues || !topValues.buckets.length) {
      return combineWithTitleAndFooter( /*#__PURE__*/_react.default.createElement("div", {
        "data-test-subj": "unifiedFieldStats-histogram"
      }, /*#__PURE__*/_react.default.createElement(_charts.Chart, {
        "data-test-subj": `${dataTestSubject}-histogram`,
        size: {
          height: 200,
          width: '100%'
        }
      }, /*#__PURE__*/_react.default.createElement(_charts.Tooltip, {
        type: _charts.TooltipType.None
      }), /*#__PURE__*/_react.default.createElement(_charts.Settings, {
        rotation: 90,
        theme: customChartTheme,
        baseTheme: chartBaseTheme
      }), /*#__PURE__*/_react.default.createElement(_charts.Axis, {
        id: "key",
        position: _charts.Position.Left,
        showOverlappingTicks: true,
        tickFormat: d => formatter.convert(d)
      }), /*#__PURE__*/_react.default.createElement(_charts.HistogramBarSeries, {
        data: histogram.buckets,
        id: specId,
        xAccessor: 'key',
        yAccessors: ['count'],
        xScaleType: _charts.ScaleType.Linear,
        yScaleType: _charts.ScaleType.Linear
      }))));
    }
  }
  if (topValues && topValues.buckets.length) {
    return combineWithTitleAndFooter( /*#__PURE__*/_react.default.createElement(_field_top_values.FieldTopValues, {
      areExamples: (0, _field_examples_calculator.showExamplesForField)(field),
      buckets: topValues.buckets,
      dataView: dataView,
      field: field,
      sampledValuesCount: sampledValues,
      color: color,
      "data-test-subj": dataTestSubject,
      onAddFilter: onAddFilter,
      overrideFieldTopValueBar: overrideFieldTopValueBar
    }));
  }
  return null;
};

/**
 * Component which fetches and renders stats for a data view field
 * @param props
 * @constructor
 */
const FieldStats = props => {
  return /*#__PURE__*/_react.default.createElement(_error_boundary.ErrorBoundary, null, /*#__PURE__*/_react.default.createElement(FieldStatsComponent, props));
};

// Necessary for React.lazy
// eslint-disable-next-line import/no-default-export
var _default = FieldStats;
exports.default = _default;
module.exports = exports.default;