"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FieldPopoverFooter = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _field_visualize_button = require("../field_visualize_button");
var _field_categorize_button = require("../field_categorize_button");
var _error_boundary = require("../error_boundary");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const FieldPopoverFooterComponent = props => {
  const [visualizeButton, setVisualizeButton] = (0, _react.useState)(null);
  const [categorizeButton, setCategorizeButton] = (0, _react.useState)(null);
  (0, _react.useEffect)(() => {
    (0, _field_visualize_button.getFieldVisualizeButton)(props).then(setVisualizeButton).catch(error => {
      // eslint-disable-next-line no-console
      console.error(error);
    });
    (0, _field_categorize_button.getFieldCategorizeButton)(props).then(setCategorizeButton).catch(error => {
      // eslint-disable-next-line no-console
      console.error(error);
    });
  }, [props]);
  return visualizeButton || categorizeButton ? /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverFooter, null, visualizeButton, visualizeButton && categorizeButton ? /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }) : null, categorizeButton) : null;
};
const FieldPopoverFooter = props => {
  return /*#__PURE__*/_react.default.createElement(_error_boundary.ErrorBoundary, null, /*#__PURE__*/_react.default.createElement(FieldPopoverFooterComponent, props));
};
exports.FieldPopoverFooter = FieldPopoverFooter;