"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _reactField = require("@kbn/react-field");
var _field_types = require("../../utils/field_types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const InnerFieldIcon = ({
  type,
  ...rest
}) => {
  return /*#__PURE__*/_react.default.createElement(_reactField.FieldIcon, (0, _extends2.default)({
    type: normalizeFieldType(type),
    label: (0, _field_types.getFieldTypeName)(type)
  }, rest));
};
const FieldIcon = /*#__PURE__*/_react.default.memo(InnerFieldIcon);

// Necessary for React.lazy
// eslint-disable-next-line import/no-default-export
var _default = FieldIcon;
exports.default = _default;
function normalizeFieldType(type) {
  return type === 'document' ? 'number' : type;
}
module.exports = exports.default;