"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EditDrilldownForm = void 0;
var React = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _useMountedState = _interopRequireDefault(require("react-use/lib/useMountedState"));
var _drilldown_manager_title = require("../drilldown_manager_title");
var _context = require("../context");
var _action_factory_view = require("../action_factory_view");
var _drilldown_manager_footer = require("../drilldown_manager_footer");
var _drilldown_state_form = require("../drilldown_state_form");
var _button_submit = require("../../components/button_submit");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const txtEditDrilldown = _i18n.i18n.translate('uiActionsEnhanced.drilldowns.containers.editDrilldownForm.title', {
  defaultMessage: 'Edit Drilldown',
  description: 'Drilldowns flyout title for edit drilldown form.'
});
const txtEditDrilldownButton = _i18n.i18n.translate('uiActionsEnhanced.drilldowns.containers.editDrilldownForm.primaryButton', {
  defaultMessage: 'Save',
  description: 'Primary button on new drilldown edit form.'
});
const EditDrilldownForm = ({
  eventId
}) => {
  const isMounted = (0, _useMountedState.default)();
  const drilldowns = (0, _context.useDrilldownManager)();
  const drilldownState = React.useMemo(() => drilldowns.createEventDrilldownState(eventId), [drilldowns, eventId]);
  const [disabled, setDisabled] = React.useState(false);
  if (!drilldownState) return null;
  const handleSave = () => {
    setDisabled(true);
    drilldowns.updateEvent(eventId, drilldownState).finally(() => {
      if (!isMounted()) return;
      setDisabled(false);
    });
  };
  return /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement(_drilldown_manager_title.DrilldownManagerTitle, null, txtEditDrilldown), /*#__PURE__*/React.createElement(_action_factory_view.ActionFactoryView, {
    constant: true,
    factory: drilldownState.factory,
    context: drilldownState.getFactoryContext()
  }), !!drilldownState && /*#__PURE__*/React.createElement(_drilldown_state_form.DrilldownStateForm, {
    state: drilldownState,
    disabled: disabled
  }), !!drilldownState && /*#__PURE__*/React.createElement(_drilldown_manager_footer.DrilldownManagerFooter, null, /*#__PURE__*/React.createElement(_button_submit.ButtonSubmit, {
    disabled: disabled,
    onClick: handleSave
  }, txtEditDrilldownButton)));
};
exports.EditDrilldownForm = EditDrilldownForm;