"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.WhenExpression = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _constants = require("../constants");
var _components = require("./components");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const WhenExpression = ({
  aggType,
  customAggTypesOptions,
  onChangeSelectedAggType,
  display = 'inline',
  popupPosition
}) => {
  const [aggTypePopoverOpen, setAggTypePopoverOpen] = (0, _react.useState)(false);
  const aggregationTypes = customAggTypesOptions !== null && customAggTypesOptions !== void 0 ? customAggTypesOptions : _constants.builtInAggregationTypes;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiExpression, {
      "data-test-subj": "whenExpression",
      description: _i18n.i18n.translate('xpack.triggersActionsUI.common.expressionItems.threshold.descriptionLabel', {
        defaultMessage: 'when'
      }),
      value: aggregationTypes[aggType].text,
      isActive: aggTypePopoverOpen,
      display: display === 'inline' ? 'inline' : 'columns',
      onClick: () => {
        setAggTypePopoverOpen(true);
      }
    }),
    isOpen: aggTypePopoverOpen,
    closePopover: () => {
      setAggTypePopoverOpen(false);
    },
    ownFocus: true,
    display: display === 'fullWidth' ? 'block' : 'inline-block',
    anchorPosition: popupPosition !== null && popupPosition !== void 0 ? popupPosition : 'downLeft',
    repositionOnScroll: true
  }, /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_components.ClosablePopoverTitle, {
    onClose: () => setAggTypePopoverOpen(false)
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.triggersActionsUI.common.expressionItems.threshold.popoverTitle",
    defaultMessage: "when"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    "data-test-subj": "whenExpressionSelect",
    id: "aggTypeField",
    value: aggType,
    fullWidth: true,
    onChange: e => {
      onChangeSelectedAggType(e.target.value);
      setAggTypePopoverOpen(false);
    },
    options: Object.values(aggregationTypes).map(({
      text,
      value
    }) => {
      return {
        text,
        value
      };
    })
  })));
};

// eslint-disable-next-line import/no-default-export
exports.default = exports.WhenExpression = WhenExpression;