"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createAppMockRenderer = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactQuery = require("@tanstack/react-query");
var _rxjs = require("rxjs");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/kibana-react-plugin/public");
var _react2 = require("@testing-library/react");
var _kibana_react = require("../../common/lib/kibana/kibana_react.mock");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createAppMockRenderer = () => {
  const services = (0, _kibana_react.createStartServicesMock)();
  const theme$ = (0, _rxjs.of)({
    darkMode: false
  });
  const queryClient = new _reactQuery.QueryClient({
    defaultOptions: {
      queries: {
        retry: false
      }
    },
    /**
     * React query prints the errors in the console even though
     * all tests are passings. We turn them off for testing.
     */
    logger: {
      log: console.log,
      warn: console.warn,
      error: () => {}
    }
  });
  const AppWrapper = /*#__PURE__*/_react.default.memo(({
    children
  }) => /*#__PURE__*/_react.default.createElement(_i18nReact.I18nProvider, null, /*#__PURE__*/_react.default.createElement(_public.KibanaContextProvider, {
    services: services
  }, /*#__PURE__*/_react.default.createElement(_public.KibanaThemeProvider, {
    theme$: theme$
  }, /*#__PURE__*/_react.default.createElement(_reactQuery.QueryClientProvider, {
    client: queryClient
  }, children)))));
  AppWrapper.displayName = 'AppWrapper';
  const render = (ui, options) => {
    return (0, _react2.render)(ui, {
      wrapper: AppWrapper,
      ...options
    });
  };
  return {
    coreStart: services,
    render,
    queryClient,
    AppWrapper
  };
};
exports.createAppMockRenderer = createAppMockRenderer;