"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.RuleStatusFilter = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const statuses = ['enabled', 'disabled', 'snoozed'];
const getOptionDataTestSubj = status => `ruleStatusFilterOption-${status}`;
const RuleStatusFilter = props => {
  const {
    selectedStatuses = [],
    dataTestSubj = 'ruleStatusFilter',
    selectDataTestSubj = 'ruleStatusFilterSelect',
    buttonDataTestSubj = 'ruleStatusFilterButton',
    optionDataTestSubj = getOptionDataTestSubj,
    onChange = () => {}
  } = props;
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const onFilterItemClick = (0, _react.useCallback)(newOption => () => {
    if (selectedStatuses.includes(newOption)) {
      onChange(selectedStatuses.filter(option => option !== newOption));
      return;
    }
    onChange([...selectedStatuses, newOption]);
  }, [selectedStatuses, onChange]);
  const onClick = (0, _react.useCallback)(() => {
    setIsPopoverOpen(prevIsOpen => !prevIsOpen);
  }, [setIsPopoverOpen]);
  const renderRuleStateOptions = status => {
    if (status === 'enabled') {
      return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.triggersActionsUI.sections.ruleDetails.ruleStateFilter.enabledOptionText",
        defaultMessage: "Rule is enabled"
      });
    } else if (status === 'disabled') {
      return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.triggersActionsUI.sections.ruleDetails.ruleStateFilter.disabledOptionText",
        defaultMessage: "Rule is disabled"
      });
    } else if (status === 'snoozed') {
      return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.triggersActionsUI.sections.ruleDetails.ruleStateFilter.snoozedOptionText",
        defaultMessage: "Rule has snoozed"
      });
    }
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFilterGroup, {
    "data-test-subj": dataTestSubj
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    isOpen: isPopoverOpen,
    closePopover: () => setIsPopoverOpen(false),
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiFilterButton, {
      "data-test-subj": buttonDataTestSubj,
      iconType: "arrowDown",
      hasActiveFilters: selectedStatuses.length > 0,
      numActiveFilters: selectedStatuses.length,
      numFilters: selectedStatuses.length,
      onClick: onClick
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.triggersActionsUI.sections.ruleDetails.ruleStateFilterButton",
      defaultMessage: "Rule state"
    }))
  }, /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": selectDataTestSubj
  }, statuses.map(status => {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiSelectableListItem, {
      key: status,
      "data-test-subj": optionDataTestSubj(status),
      onClick: onFilterItemClick(status),
      checked: selectedStatuses.includes(status) ? 'on' : undefined
    }, renderRuleStateOptions(status));
  }))));
};

// eslint-disable-next-line import/no-default-export
exports.default = exports.RuleStatusFilter = RuleStatusFilter;