"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getConvertedAlertStatus = exports.default = exports.RuleAlertList = void 0;
var _react = _interopRequireWildcard(require("react"));
var _moment = _interopRequireDefault(require("moment"));
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _services = require("@elastic/eui/lib/services");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _constants = require("../../../constants");
var _alert_muted_switch = require("./alert_muted_switch");
var _alert_lifecycle_status_badge = require("../../../components/alert_lifecycle_status_badge");
var _use_bulk_get_maintenance_windows = require("../../alerts_table/hooks/use_bulk_get_maintenance_windows");
var _cell = require("../../alerts_table/maintenance_windows/cell");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getConvertedAlertStatus = status => {
  if (status === 'Active') {
    return _ruleDataUtils.ALERT_STATUS_ACTIVE;
  }
  return _ruleDataUtils.ALERT_STATUS_RECOVERED;
};
exports.getConvertedAlertStatus = getConvertedAlertStatus;
const durationAsString = duration => {
  return [duration.hours(), duration.minutes(), duration.seconds()].map(value => (0, _lodash.padStart)(`${value}`, 2, '0')).join(':');
};
const getRowProps = () => ({
  'data-test-subj': 'alert-row'
});
const getCellProps = () => ({
  'data-test-subj': 'cell'
});
function getPage(items, pagination) {
  return (0, _lodash.chunk)(items, pagination.size)[pagination.index] || [];
}
const isMaintenanceWindowValid = mw => {
  return !!mw;
};
const RuleAlertListMaintenanceWindowCell = props => {
  var _alert$start;
  const {
    alert,
    maintenanceWindows,
    isLoading
  } = props;
  const validMaintenanceWindows = (0, _react.useMemo)(() => {
    const maintenanceWindowIds = alert.maintenanceWindowIds || [];
    return maintenanceWindowIds.map(id => maintenanceWindows.get(id)).filter(isMaintenanceWindowValid);
  }, [alert, maintenanceWindows]);
  const idsWithoutMaintenanceWindow = (0, _react.useMemo)(() => {
    const maintenanceWindowIds = alert.maintenanceWindowIds || [];
    return maintenanceWindowIds.filter(id => !maintenanceWindows.get(id));
  }, [alert, maintenanceWindows]);
  return /*#__PURE__*/_react.default.createElement(_cell.MaintenanceWindowBaseCell, {
    timestamp: (_alert$start = alert.start) === null || _alert$start === void 0 ? void 0 : _alert$start.toISOString(),
    maintenanceWindows: validMaintenanceWindows,
    maintenanceWindowIds: idsWithoutMaintenanceWindow,
    isLoading: isLoading
  });
};
const RuleAlertList = props => {
  const {
    items,
    readOnly,
    onMuteAction
  } = props;
  const [pagination, setPagination] = (0, _react.useState)({
    index: 0,
    size: _constants.DEFAULT_SEARCH_PAGE_SIZE
  });
  const pageOfAlerts = (0, _react.useMemo)(() => getPage(items, pagination), [items, pagination]);
  const paginationOptions = (0, _react.useMemo)(() => {
    return {
      pageIndex: pagination.index,
      pageSize: pagination.size,
      totalItemCount: items.length
    };
  }, [pagination, items]);
  const maintenanceWindowIds = (0, _react.useMemo)(() => {
    return new Set(pageOfAlerts.map(alert => alert.maintenanceWindowIds || []).flat());
  }, [pageOfAlerts]);
  const {
    data: maintenanceWindows,
    isFetching: isLoadingMaintenanceWindows
  } = (0, _use_bulk_get_maintenance_windows.useBulkGetMaintenanceWindows)({
    ids: Array.from(maintenanceWindowIds.values()),
    canFetchMaintenanceWindows: true
  });
  const alertsTableColumns = (0, _react.useMemo)(() => [{
    field: 'alert',
    name: _i18n.i18n.translate('xpack.triggersActionsUI.sections.ruleDetails.alertsList.columns.Alert', {
      defaultMessage: 'Alert'
    }),
    sortable: false,
    truncateText: true,
    width: '45%',
    'data-test-subj': 'alertsTableCell-alert',
    render: value => {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
        anchorClassName: 'eui-textTruncate',
        content: value
      }, /*#__PURE__*/_react.default.createElement("span", null, value));
    }
  }, {
    field: 'status',
    name: _i18n.i18n.translate('xpack.triggersActionsUI.sections.ruleDetails.alertsList.columns.status', {
      defaultMessage: 'Status'
    }),
    width: '15%',
    render: (value, alert) => {
      const convertedStatus = getConvertedAlertStatus(value);
      return /*#__PURE__*/_react.default.createElement(_alert_lifecycle_status_badge.AlertLifecycleStatusBadge, {
        alertStatus: convertedStatus,
        flapping: alert.flapping
      });
    },
    sortable: false,
    'data-test-subj': 'alertsTableCell-status'
  }, {
    field: 'start',
    width: '190px',
    render: value => {
      return value ? (0, _moment.default)(value).format('D MMM YYYY @ HH:mm:ss') : '';
    },
    name: _i18n.i18n.translate('xpack.triggersActionsUI.sections.ruleDetails.alertsList.columns.start', {
      defaultMessage: 'Start'
    }),
    sortable: false,
    'data-test-subj': 'alertsTableCell-start'
  }, {
    field: 'duration',
    render: value => {
      return value ? durationAsString(_moment.default.duration(value)) : '';
    },
    name: _i18n.i18n.translate('xpack.triggersActionsUI.sections.ruleDetails.alertsList.columns.duration', {
      defaultMessage: 'Duration'
    }),
    sortable: false,
    width: '80px',
    'data-test-subj': 'alertsTableCell-duration'
  }, {
    field: '',
    width: '250px',
    render: alert => {
      return /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(RuleAlertListMaintenanceWindowCell, {
        alert: alert,
        maintenanceWindows: maintenanceWindows || new Map(),
        isLoading: isLoadingMaintenanceWindows
      }));
    },
    name: _i18n.i18n.translate('xpack.triggersActionsUI.sections.ruleDetails.alertsList.columns.maintenanceWindowIds', {
      defaultMessage: 'Maintenance windows'
    }),
    sortable: false,
    'data-test-subj': 'alertsTableCell-maintenanceWindowIds'
  }, {
    field: '',
    align: _services.RIGHT_ALIGNMENT,
    width: '60px',
    name: _i18n.i18n.translate('xpack.triggersActionsUI.sections.ruleDetails.alertsList.columns.mute', {
      defaultMessage: 'Mute'
    }),
    render: alert => {
      return /*#__PURE__*/_react.default.createElement(_alert_muted_switch.AlertMutedSwitch, {
        disabled: readOnly,
        onMuteAction: async () => await onMuteAction(alert),
        alert: alert
      });
    },
    sortable: false,
    'data-test-subj': 'alertsTableCell-actions'
  }], [maintenanceWindows, isLoadingMaintenanceWindows, onMuteAction, readOnly]);
  const onChange = (0, _react.useCallback)(({
    page: changedPage
  }) => {
    setPagination(changedPage);
  }, [setPagination]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    items: pageOfAlerts,
    pagination: paginationOptions,
    onChange: onChange,
    rowProps: getRowProps,
    cellProps: getCellProps,
    columns: alertsTableColumns,
    "data-test-subj": "alertsList",
    tableLayout: "fixed",
    className: "alertsList"
  });
};

// eslint-disable-next-line import/no-default-export
exports.default = exports.RuleAlertList = RuleAlertList;