"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BulkOperationPopover = void 0;
var _react = _interopRequireWildcard(require("react"));
var _numeral = _interopRequireDefault(require("@elastic/numeral"));
var _public = require("@kbn/kibana-react-plugin/public");
var _eui = require("@elastic/eui");
var _translations = require("../../rules_list/translations");
var _constants = require("../../../constants");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const BulkOperationPopover = props => {
  const {
    children,
    numberOfSelectedRules = 0,
    canModifySelectedRules
  } = props;
  const [defaultNumberFormat] = (0, _public.useUiSetting$)(_constants.DEFAULT_NUMBER_FORMAT);
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const formattedSelectedRules = (0, _react.useMemo)(() => {
    return (0, _numeral.default)(numberOfSelectedRules).format(defaultNumberFormat);
  }, [numberOfSelectedRules, defaultNumberFormat]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    isOpen: isPopoverOpen,
    closePopover: () => setIsPopoverOpen(false),
    "data-test-subj": "bulkAction",
    panelPaddingSize: "s",
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      size: "xs",
      iconSide: "right",
      iconType: canModifySelectedRules ? 'arrowDown' : undefined,
      disabled: !canModifySelectedRules,
      "aria-label": _translations.SELECT_SHOW_BULK_ACTIONS_ARIA_LABEL,
      "data-test-subj": "showBulkActionButton",
      onClick: () => setIsPopoverOpen(!isPopoverOpen)
    }, (0, _translations.SELECTED_RULES)(formattedSelectedRules, numberOfSelectedRules))
  }, children && _react.default.Children.map(children, child => /*#__PURE__*/_react.default.isValidElement(child) ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.cloneElement(child, {})) : child));
};
exports.BulkOperationPopover = BulkOperationPopover;