"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ModalInspectQuery = void 0;
var _eui = require("@elastic/eui");
var _numeral = _interopRequireDefault(require("@elastic/numeral"));
var _react = _interopRequireDefault(require("react"));
var _common = require("@kbn/kibana-react-plugin/common");
var _lodash = require("lodash");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DescriptionListStyled = (0, _common.euiStyled)(_eui.EuiDescriptionList)`
  @media only screen and (min-width: ${({
  theme
}) => theme.eui.euiBreakpoints.s}) {
    .euiDescriptionList__title {
      width: 30% !important;
    }

    .euiDescriptionList__description {
      width: 70% !important;
    }
  }
`;
DescriptionListStyled.displayName = 'DescriptionListStyled';
const MyEuiModal = (0, _common.euiStyled)(_eui.EuiModal)`
  width: min(768px, calc(100vw - 16px));
  min-height: 41vh;
  .euiModal__flex {
    width: 60vw;
  }
  .euiCodeBlock {
    height: auto !important;
    max-width: 718px;
  }
`;
MyEuiModal.displayName = 'MyEuiModal';
const parse = function (str) {
  try {
    return JSON.parse(str);
  } catch {
    return {};
  }
};
const stringify = object => {
  try {
    return JSON.stringify(object, null, 2);
  } catch {
    return i18n.SOMETHING_WENT_WRONG;
  }
};
const ModalInspectQueryComponent = ({
  closeModal,
  getInspectQuery,
  title
}) => {
  var _parsedRequest$index$, _parsedRequest$index;
  const {
    request,
    response
  } = getInspectQuery();
  // using index 0 as there will be only one request and response for now
  const parsedRequest = parse(request[0]);
  const parsedResponse = parse(response[0]);
  const formattedRequest = stringify(parsedRequest);
  const formattedResponse = stringify(parsedResponse);
  const statistics = [{
    title: /*#__PURE__*/_react.default.createElement("span", {
      "data-test-subj": "index-pattern-title"
    }, i18n.INDEX_PATTERN, ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      color: "subdued",
      content: i18n.INDEX_PATTERN_DESC,
      type: "iInCircle"
    })),
    description: /*#__PURE__*/_react.default.createElement("span", {
      "data-test-subj": "index-pattern-description"
    }, /*#__PURE__*/_react.default.createElement("p", null, (_parsedRequest$index$ = (_parsedRequest$index = parsedRequest.index) === null || _parsedRequest$index === void 0 ? void 0 : _parsedRequest$index.join(', ')) !== null && _parsedRequest$index$ !== void 0 ? _parsedRequest$index$ : []))
  }, {
    title: /*#__PURE__*/_react.default.createElement("span", {
      "data-test-subj": "query-time-title"
    }, i18n.QUERY_TIME, ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      color: "subdued",
      content: i18n.QUERY_TIME_DESC,
      type: "iInCircle"
    })),
    description: /*#__PURE__*/_react.default.createElement("span", {
      "data-test-subj": "query-time-description"
    }, parsedResponse.took === 0 ? '0ms' : parsedResponse.took ? `${(0, _numeral.default)(parsedResponse.took).format('0,0')}ms` : i18n.SOMETHING_WENT_WRONG)
  }, {
    title: /*#__PURE__*/_react.default.createElement("span", {
      "data-test-subj": "request-timestamp-title"
    }, i18n.REQUEST_TIMESTAMP, ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      color: "subdued",
      content: i18n.REQUEST_TIMESTAMP_DESC,
      type: "iInCircle"
    })),
    description: /*#__PURE__*/_react.default.createElement("span", {
      "data-test-subj": "request-timestamp-description"
    }, new Date().toISOString())
  }];
  const tabs = [{
    id: 'statistics',
    name: 'Statistics',
    content: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(DescriptionListStyled, {
      listItems: statistics,
      type: "column"
    }))
  }, {
    id: 'request',
    name: 'Request',
    content: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
      language: "js",
      fontSize: "m",
      paddingSize: "m",
      color: "dark",
      overflowHeight: 300,
      isCopyable: true
    }, (0, _lodash.isEmpty)(parsedRequest) ? i18n.SOMETHING_WENT_WRONG : formattedRequest))
  }, {
    id: 'response',
    name: 'Response',
    content: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
      language: "js",
      fontSize: "m",
      paddingSize: "m",
      color: "dark",
      overflowHeight: 300,
      isCopyable: true
    }, (0, _lodash.isEmpty)(parsedResponse) ? i18n.SOMETHING_WENT_WRONG : formattedResponse))
  }];
  return /*#__PURE__*/_react.default.createElement(MyEuiModal, {
    onClose: closeModal,
    "data-test-subj": "modal-inspect-euiModal"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, null, i18n.INSPECT, " ", title)), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTabbedContent, {
    tabs: tabs,
    initialSelectedTab: tabs[0],
    autoFocus: "selected"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiModalFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    onClick: closeModal,
    fill: true,
    "data-test-subj": "modal-inspect-close"
  }, i18n.CLOSE)));
};
const ModalInspectQuery = /*#__PURE__*/_react.default.memo(ModalInspectQueryComponent);
exports.ModalInspectQuery = ModalInspectQuery;