"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AlertLifecycleStatusCell = void 0;
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _react = _interopRequireWildcard(require("react"));
var _alert_lifecycle_status_badge = require("../../../components/alert_lifecycle_status_badge");
var _default_cell = require("./default_cell");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AlertLifecycleStatusCellComponent = props => {
  var _alert$ALERT_STATUS;
  const {
    alert,
    showAlertStatusWithFlapping
  } = props;
  if (!showAlertStatusWithFlapping) {
    return null;
  }
  const alertStatus = (_alert$ALERT_STATUS = alert[_ruleDataUtils.ALERT_STATUS]) !== null && _alert$ALERT_STATUS !== void 0 ? _alert$ALERT_STATUS : [];
  if (Array.isArray(alertStatus) && alertStatus.length) {
    var _alert$ALERT_FLAPPING;
    const flapping = (_alert$ALERT_FLAPPING = alert[_ruleDataUtils.ALERT_FLAPPING]) !== null && _alert$ALERT_FLAPPING !== void 0 ? _alert$ALERT_FLAPPING : [];
    return /*#__PURE__*/_react.default.createElement(_alert_lifecycle_status_badge.AlertLifecycleStatusBadge, {
      alertStatus: alertStatus.join(),
      flapping: flapping[0]
    });
  }
  return /*#__PURE__*/_react.default.createElement(_default_cell.DefaultCell, props);
};
AlertLifecycleStatusCellComponent.displayName = 'AlertLifecycleStatusCell';
const AlertLifecycleStatusCell = /*#__PURE__*/(0, _react.memo)(AlertLifecycleStatusCellComponent);
exports.AlertLifecycleStatusCell = AlertLifecycleStatusCell;