"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.AlertsSearchBar = AlertsSearchBar;
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/kibana-react-plugin/public");
var _constants = require("./constants");
var _translations = require("./translations");
var _use_alert_data_view = require("../../hooks/use_alert_data_view");
var _use_rule_aad_fields = require("../../hooks/use_rule_aad_fields");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// TODO Share buildEsQuery to be used between AlertsSearchBar and AlertsStateTable component https://github.com/elastic/kibana/issues/144615
function AlertsSearchBar({
  appName,
  disableQueryLanguageSwitcher = false,
  featureIds,
  ruleTypeId,
  query,
  filters,
  onQueryChange,
  onQuerySubmit,
  onFiltersUpdated,
  rangeFrom,
  rangeTo,
  showFilterBar = false,
  showDatePicker = true,
  showSubmitButton = true,
  placeholder = _translations.SEARCH_BAR_PLACEHOLDER,
  submitOnBlur = false
}) {
  const {
    unifiedSearch: {
      ui: {
        SearchBar
      }
    }
  } = (0, _public.useKibana)().services;
  const [queryLanguage, setQueryLanguage] = (0, _react.useState)('kuery');
  const {
    value: dataView,
    loading,
    error
  } = (0, _use_alert_data_view.useAlertDataView)(featureIds);
  const {
    value: aadFields,
    loading: fieldsLoading,
    error: fieldsError
  } = (0, _use_rule_aad_fields.useRuleAADFields)(ruleTypeId);
  const indexPatterns = ruleTypeId && aadFields !== null && aadFields !== void 0 && aadFields.length ? [{
    title: ruleTypeId,
    fields: aadFields
  }] : [dataView];
  const onSearchQuerySubmit = (0, _react.useCallback)(({
    dateRange,
    query: nextQuery
  }) => {
    var _nextQuery$language;
    onQuerySubmit({
      dateRange,
      query: typeof (nextQuery === null || nextQuery === void 0 ? void 0 : nextQuery.query) === 'string' ? nextQuery.query : undefined
    });
    setQueryLanguage((_nextQuery$language = nextQuery === null || nextQuery === void 0 ? void 0 : nextQuery.language) !== null && _nextQuery$language !== void 0 ? _nextQuery$language : 'kuery');
  }, [onQuerySubmit, setQueryLanguage]);
  const onSearchQueryChange = (0, _react.useCallback)(({
    dateRange,
    query: nextQuery
  }) => {
    var _nextQuery$language2;
    onQueryChange === null || onQueryChange === void 0 ? void 0 : onQueryChange({
      dateRange,
      query: typeof (nextQuery === null || nextQuery === void 0 ? void 0 : nextQuery.query) === 'string' ? nextQuery.query : undefined
    });
    setQueryLanguage((_nextQuery$language2 = nextQuery === null || nextQuery === void 0 ? void 0 : nextQuery.language) !== null && _nextQuery$language2 !== void 0 ? _nextQuery$language2 : 'kuery');
  }, [onQueryChange, setQueryLanguage]);
  const onRefresh = ({
    dateRange
  }) => {
    onQuerySubmit({
      dateRange
    });
  };
  return /*#__PURE__*/_react.default.createElement(SearchBar, {
    appName: appName,
    disableQueryLanguageSwitcher: disableQueryLanguageSwitcher
    // @ts-expect-error - DataView fields prop and SearchBar indexPatterns props are overly broad
    ,
    indexPatterns: loading || error || fieldsLoading || fieldsError ? _constants.NO_INDEX_PATTERNS : indexPatterns,
    placeholder: placeholder,
    query: {
      query: query !== null && query !== void 0 ? query : '',
      language: queryLanguage
    },
    filters: filters,
    dateRangeFrom: rangeFrom,
    dateRangeTo: rangeTo,
    displayStyle: "inPage",
    showFilterBar: showFilterBar,
    onQuerySubmit: onSearchQuerySubmit,
    onFiltersUpdated: onFiltersUpdated,
    onRefresh: onRefresh,
    showDatePicker: showDatePicker,
    showQueryInput: true,
    showSaveQuery: true,
    showSubmitButton: showSubmitButton,
    submitOnBlur: submitOnBlur,
    onQueryChange: onSearchQueryChange
  });
}

// eslint-disable-next-line import/no-default-export