"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.EditConnectorFlyout = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _common = require("@kbn/actions-plugin/common");
var _Option = require("fp-ts/lib/Option");
var _types = require("../../../../types");
var _connector_form = require("../connector_form");
var _use_edit_connector = require("../../../hooks/use_edit_connector");
var _kibana = require("../../../../common/lib/kibana");
var _capabilities = require("../../../lib/capabilities");
var _test_connector_form = _interopRequireDefault(require("../test_connector_form"));
var _use_execute_connector = require("../../../hooks/use_execute_connector");
var _header = require("./header");
var _footer = require("./footer");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getConnectorWithoutSecrets = connector => {
  var _connector$isMissingS;
  return {
    ...connector,
    isMissingSecrets: (_connector$isMissingS = connector.isMissingSecrets) !== null && _connector$isMissingS !== void 0 ? _connector$isMissingS : false,
    secrets: {}
  };
};
const ReadOnlyConnectorMessage = ({
  href
}) => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, _i18n.i18n.translate('xpack.triggersActionsUI.sections.editConnectorForm.descriptionText', {
    defaultMessage: 'This connector is readonly.'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: href,
    target: "_blank"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.triggersActionsUI.sections.editConnectorForm.preconfiguredHelpLabel",
    defaultMessage: "Learn more about preconfigured connectors."
  })));
};
const EditConnectorFlyoutComponent = ({
  actionTypeRegistry,
  connector,
  onClose,
  tab = _types.EditConnectorTabs.Configuration,
  onConnectorUpdated
}) => {
  const {
    docLinks,
    application: {
      capabilities
    }
  } = (0, _kibana.useKibana)().services;
  const isMounted = (0, _react.useRef)(false);
  const canSave = (0, _capabilities.hasSaveActionsCapability)(capabilities);
  const {
    isLoading: isUpdatingConnector,
    updateConnector
  } = (0, _use_edit_connector.useUpdateConnector)();
  const {
    isLoading: isExecutingConnector,
    executeConnector
  } = (0, _use_execute_connector.useExecuteConnector)();
  const [preSubmitValidationErrorMessage, setPreSubmitValidationErrorMessage] = (0, _react.useState)(null);
  const [formState, setFormState] = (0, _react.useState)({
    isSubmitted: false,
    isSubmitting: false,
    isValid: undefined,
    submit: async () => ({
      isValid: false,
      data: {}
    }),
    preSubmitValidator: null
  });
  const [selectedTab, setTab] = (0, _react.useState)(tab);
  /**
   * Test connector
   */

  const [testExecutionActionParams, setTestExecutionActionParams] = (0, _react.useState)({});
  const [testExecutionResult, setTestExecutionResult] = (0, _react.useState)(_Option.none);
  const handleSetTab = (0, _react.useCallback)(() => setTab(prevTab => {
    if (prevTab === _types.EditConnectorTabs.Configuration) {
      return _types.EditConnectorTabs.Test;
    }
    if (testExecutionResult !== _Option.none) {
      setTestExecutionResult(_Option.none);
    }
    return _types.EditConnectorTabs.Configuration;
  }), [testExecutionResult]);
  const [isFormModified, setIsFormModified] = (0, _react.useState)(false);
  const [showConfirmModal, setShowConfirmModal] = (0, _react.useState)(false);
  const [isEdit, setIsEdit] = (0, _react.useState)(true);
  const [isSaved, setIsSaved] = (0, _react.useState)(false);
  const {
    preSubmitValidator,
    submit,
    isValid: isFormValid,
    isSubmitting
  } = formState;
  const hasErrors = isFormValid === false;
  const isSaving = isUpdatingConnector || isSubmitting || isExecutingConnector;
  const actionTypeModel = actionTypeRegistry.get(connector.actionTypeId);
  const showButtons = canSave && actionTypeModel && !connector.isPreconfigured;
  const onExecutionAction = (0, _react.useCallback)(async () => {
    try {
      const res = await executeConnector({
        connectorId: connector.id,
        params: testExecutionActionParams
      });
      setTestExecutionResult((0, _Option.some)(res));
    } catch (error) {
      const result = (0, _common.isActionTypeExecutorResult)(error) ? error : {
        actionId: connector.id,
        status: 'error',
        message: error.message
      };
      setTestExecutionResult((0, _Option.some)(result));
    }
  }, [connector.id, executeConnector, testExecutionActionParams]);
  const onFormModifiedChange = (0, _react.useCallback)(formModified => {
    if (formModified) {
      setIsSaved(false);
    }
    setIsFormModified(formModified);
    setTestExecutionResult(_Option.none);
  }, [setIsFormModified]);
  const closeFlyout = (0, _react.useCallback)(() => {
    if (isFormModified) {
      setShowConfirmModal(true);
      return;
    }
    onClose();
  }, [onClose, isFormModified, setShowConfirmModal]);
  const onClickSave = (0, _react.useCallback)(async () => {
    setPreSubmitValidationErrorMessage(null);
    const {
      isValid,
      data
    } = await submit();
    if (!isMounted.current) {
      // User has closed the flyout meanwhile submitting the form
      return;
    }
    if (isValid) {
      if (preSubmitValidator) {
        const validatorRes = await preSubmitValidator();
        if (validatorRes) {
          setPreSubmitValidationErrorMessage(validatorRes.message);
          return;
        }
      }

      /**
       * At this point the form is valid
       * and there are no pre submit error messages.
       */

      const {
        name,
        config,
        secrets
      } = data;
      const validConnector = {
        id: connector.id,
        name: name !== null && name !== void 0 ? name : '',
        config: config !== null && config !== void 0 ? config : {},
        secrets: secrets !== null && secrets !== void 0 ? secrets : {}
      };
      const updatedConnector = await updateConnector(validConnector);
      if (updatedConnector) {
        /**
         * ConnectorFormSchema has been saved.
         * Set the from to clean state.
         */
        onFormModifiedChange(false);
        if (onConnectorUpdated) {
          onConnectorUpdated(updatedConnector);
        }
        setIsSaved(true);
        setIsEdit(false);
        setIsEdit(true);
      }
      return updatedConnector;
    }
  }, [onConnectorUpdated, submit, preSubmitValidator, connector.id, updateConnector, onFormModifiedChange]);
  (0, _react.useEffect)(() => {
    isMounted.current = true;
    return () => {
      isMounted.current = false;
    };
  }, []);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    onClose: closeFlyout,
    "aria-labelledby": "flyoutActionEditTitle",
    size: "m",
    "data-test-subj": "edit-connector-flyout"
  }, /*#__PURE__*/_react.default.createElement(_header.FlyoutHeader, {
    isPreconfigured: connector.isPreconfigured,
    connectorName: connector.name,
    connectorTypeDesc: actionTypeModel === null || actionTypeModel === void 0 ? void 0 : actionTypeModel.selectMessage,
    setTab: handleSetTab,
    selectedTab: selectedTab,
    icon: actionTypeModel === null || actionTypeModel === void 0 ? void 0 : actionTypeModel.iconClass,
    isExperimental: actionTypeModel === null || actionTypeModel === void 0 ? void 0 : actionTypeModel.isExperimental
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, null, selectedTab === _types.EditConnectorTabs.Configuration ? !connector.isPreconfigured ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, isEdit && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_connector_form.ConnectorForm, {
    actionTypeModel: actionTypeModel,
    connector: getConnectorWithoutSecrets(connector),
    isEdit: isEdit,
    onChange: setFormState,
    onFormModifiedChange: onFormModifiedChange
  }), !!preSubmitValidationErrorMessage && /*#__PURE__*/_react.default.createElement("p", null, preSubmitValidationErrorMessage), showButtons && /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: true,
    iconType: isSaved ? 'check' : undefined,
    color: "success",
    "data-test-subj": "edit-connector-flyout-save-btn",
    isLoading: isSaving,
    onClick: onClickSave,
    disabled: !isFormModified || hasErrors || isSaving
  }, isSaved ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.triggersActionsUI.sections.editConnectorForm.saveButtonSavedLabel",
    defaultMessage: "Changes Saved"
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.triggersActionsUI.sections.editConnectorForm.saveButtonLabel",
    defaultMessage: "Save"
  })))) : /*#__PURE__*/_react.default.createElement(ReadOnlyConnectorMessage, {
    href: docLinks.links.alerting.preconfiguredConnectors
  }) : /*#__PURE__*/_react.default.createElement(_test_connector_form.default, {
    connector: connector,
    executeEnabled: !isFormModified,
    actionParams: testExecutionActionParams,
    setActionParams: setTestExecutionActionParams,
    onExecutionAction: onExecutionAction,
    isExecutingAction: isExecutingConnector,
    executionResult: testExecutionResult,
    actionTypeRegistry: actionTypeRegistry
  })), /*#__PURE__*/_react.default.createElement(_footer.FlyoutFooter, {
    onClose: closeFlyout
  })), showConfirmModal && /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    buttonColor: "danger",
    "data-test-subj": "closeConnectorEditConfirm",
    title: _i18n.i18n.translate('xpack.triggersActionsUI.sections.confirmConnectorEditClose.title', {
      defaultMessage: 'Discard unsaved changes to connector?'
    }),
    onCancel: () => {
      setShowConfirmModal(false);
    },
    onConfirm: onClose,
    cancelButtonText: _i18n.i18n.translate('xpack.triggersActionsUI.sections.confirmConnectorEditClose.cancelButtonLabel', {
      defaultMessage: 'Cancel'
    }),
    confirmButtonText: _i18n.i18n.translate('xpack.triggersActionsUI.sections.confirmConnectorEditClose.discardButtonLabel', {
      defaultMessage: 'Discard Changes'
    })
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.triggersActionsUI.sections.confirmConnectorEditClose.confirmConnectorCloseMessage",
    defaultMessage: "You can't recover unsaved changes."
  })));
};
const EditConnectorFlyout = /*#__PURE__*/(0, _react.memo)(EditConnectorFlyoutComponent);

// eslint-disable-next-line import/no-default-export
exports.default = exports.EditConnectorFlyout = EditConnectorFlyout;