"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FlyoutHeader = void 0;
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _beta_badge_props = require("../beta_badge_props");
var _types = require("../../../../types");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FlyoutHeaderComponent = ({
  icon,
  isExperimental = false,
  isPreconfigured,
  connectorName,
  connectorTypeDesc,
  selectedTab,
  setTab
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true,
    "data-test-subj": "edit-connector-flyout-header"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: "center"
  }, icon ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: icon,
    size: "m",
    "data-test-subj": "edit-connector-flyout-header-icon"
  })) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, isPreconfigured ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    justifyContent: "center",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h3", {
    id: "flyoutTitle"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    defaultMessage: "{connectorName}",
    id: "xpack.triggersActionsUI.sections.preconfiguredConnectorForm.flyoutTitle",
    values: {
      connectorName
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBetaBadge, {
    label: "Preconfigured",
    "data-test-subj": "preconfiguredBadge",
    tooltipContent: _i18n.i18n.translate('xpack.triggersActionsUI.sections.preconfiguredConnectorForm.tooltipContent', {
      defaultMessage: 'This connector is preconfigured and cannot be edited'
    })
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, isExperimental && /*#__PURE__*/_react.default.createElement(_eui.EuiBetaBadge, {
    label: _beta_badge_props.betaBadgeProps.label,
    tooltipContent: _beta_badge_props.betaBadgeProps.tooltipContent
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    defaultMessage: "{connectorTypeDesc}",
    id: "xpack.triggersActionsUI.sections.editConnectorForm.actionTypeDescription",
    values: {
      connectorTypeDesc
    }
  }))) : /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    justifyContent: "center",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h3", {
    id: "flyoutTitle"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    defaultMessage: "Edit connector",
    id: "xpack.triggersActionsUI.sections.editConnectorForm.flyoutPreconfiguredTitle"
  })))), isExperimental && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBetaBadge, {
    label: _beta_badge_props.betaBadgeProps.label,
    tooltipContent: _beta_badge_props.betaBadgeProps.tooltipContent
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiTabs, {
    className: "connectorEditFlyoutTabs",
    bottomBorder: false,
    css: (0, _react2.css)`
          margin-bottom: -${euiTheme.size.l};
        `
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
    onClick: setTab,
    "data-test-subj": "configureConnectorTab",
    isSelected: _types.EditConnectorTabs.Configuration === selectedTab
  }, _i18n.i18n.translate('xpack.triggersActionsUI.sections.editConnectorForm.tabText', {
    defaultMessage: 'Configuration'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
    onClick: setTab,
    "data-test-subj": "testConnectorTab",
    isSelected: _types.EditConnectorTabs.Test === selectedTab
  }, _i18n.i18n.translate('xpack.triggersActionsUI.sections.testConnectorForm.tabText', {
    defaultMessage: 'Test'
  }))));
};
const FlyoutHeader = /*#__PURE__*/(0, _react.memo)(FlyoutHeaderComponent);
exports.FlyoutHeader = FlyoutHeader;