"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.validateParamsForWarnings = validateParamsForWarnings;
var _lodash = require("lodash");
var _i18n = require("@kbn/i18n");
var _mustache = _interopRequireDefault(require("mustache"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const publicUrlWarning = _i18n.i18n.translate('xpack.triggersActionsUI.sections.actionTypeForm.warning.publicUrl', {
  defaultMessage: 'server.publicBaseUrl is not set. Generated URLs will be either relative or empty.'
});
function validateParamsForWarnings(value, publicBaseUrl, actionVariables) {
  if (!publicBaseUrl && value && typeof value === 'string') {
    const publicUrlFields = (actionVariables || []).reduce((acc, v) => {
      if (v.usesPublicBaseUrl) {
        acc.push(v.name.replace(/^(params\.|context\.|state\.)/, ''));
        acc.push(v.name);
      }
      return acc;
    }, new Array());
    try {
      const variables = new Set(_mustache.default.parse(value).filter(([type]) => type === 'name').map(([, v]) => v));
      const hasUrlFields = (0, _lodash.some)(publicUrlFields, publicUrlField => variables.has(publicUrlField));
      if (hasUrlFields) {
        return publicUrlWarning;
      }
    } catch (e) {
      /*
       * do nothing, we don't care if the mustache is invalid
       */
    }
  }
  return null;
}