"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.executeAction = executeAction;
var _constants = require("../../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const rewriteBodyRes = ({
  connector_id: actionId,
  service_message: serviceMessage,
  ...res
}) => ({
  ...res,
  actionId,
  serviceMessage
});
async function executeAction({
  id,
  params,
  http,
  signal
}) {
  const res = await http.post(`${_constants.BASE_ACTION_API_PATH}/connector/${encodeURIComponent(id)}/_execute`, {
    body: JSON.stringify({
      params
    }),
    signal
  });
  return rewriteBodyRes(res);
}