"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useRuleAADFields = useRuleAADFields;
var _public = require("@kbn/kibana-react-plugin/public");
var _common = require("@kbn/rule-registry-plugin/common");
var _useAsync = _interopRequireDefault(require("react-use/lib/useAsync"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useRuleAADFields(ruleTypeId) {
  const {
    http
  } = (0, _public.useKibana)().services;
  const aadFields = (0, _useAsync.default)(async () => {
    if (!ruleTypeId) return [];
    const fields = await http.get(`${_common.BASE_RAC_ALERTS_API_PATH}/aad_fields`, {
      query: {
        ruleTypeId
      }
    });
    return fields;
  });
  return aadFields;
}