"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useLoadRuleAggregationsQuery = void 0;
var _i18n = require("@kbn/i18n");
var _reactQuery = require("@tanstack/react-query");
var _common = require("@kbn/alerting-plugin/common");
var _aggregate_kuery_filter = require("../lib/rule_api/aggregate_kuery_filter");
var _kibana = require("../../common/lib/kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const initializeAggregationResult = values => {
  return values.reduce((prev, status) => ({
    ...prev,
    [status]: 0
  }), {});
};
const useLoadRuleAggregationsQuery = props => {
  var _aggregation$ruleExec, _aggregation$ruleLast;
  const {
    filters,
    enabled,
    refresh
  } = props;
  const {
    http,
    notifications: {
      toasts
    }
  } = (0, _kibana.useKibana)().services;
  const internalLoadRuleAggregations = () => {
    return (0, _aggregate_kuery_filter.loadRuleAggregationsWithKueryFilter)({
      http,
      searchText: filters.searchText,
      typesFilter: filters.types,
      actionTypesFilter: filters.actionTypes,
      ruleExecutionStatusesFilter: filters.ruleExecutionStatuses,
      ruleLastRunOutcomesFilter: filters.ruleLastRunOutcomes,
      ruleStatusesFilter: filters.ruleStatuses,
      tagsFilter: filters.tags
    });
  };
  const onErrorFn = () => {
    toasts.addDanger(_i18n.i18n.translate('xpack.triggersActionsUI.sections.rulesList.unableToLoadRuleStatusInfoMessage', {
      defaultMessage: 'Unable to load rule status info'
    }));
  };
  const {
    data,
    refetch,
    isLoading,
    isFetching
  } = (0, _reactQuery.useQuery)({
    queryKey: ['loadRuleAggregationsWithKueryFilter', filters.searchText, filters.types, filters.actionTypes, filters.ruleExecutionStatuses, filters.ruleLastRunOutcomes, filters.ruleStatuses, filters.tags, {
      refresh: refresh === null || refresh === void 0 ? void 0 : refresh.toISOString()
    }],
    queryFn: internalLoadRuleAggregations,
    onError: onErrorFn,
    enabled,
    keepPreviousData: true,
    cacheTime: 0,
    refetchOnWindowFocus: false
  });
  const aggregation = data ? data : {
    ruleExecutionStatus: initializeAggregationResult(_common.RuleExecutionStatusValues),
    ruleLastRunOutcome: initializeAggregationResult(_common.RuleLastRunOutcomeValues)
  };
  return {
    loadRuleAggregations: refetch,
    rulesStatusesTotal: (_aggregation$ruleExec = aggregation.ruleExecutionStatus) !== null && _aggregation$ruleExec !== void 0 ? _aggregation$ruleExec : {},
    rulesLastRunOutcomesTotal: (_aggregation$ruleLast = aggregation.ruleLastRunOutcome) !== null && _aggregation$ruleLast !== void 0 ? _aggregation$ruleLast : {},
    isLoading: isLoading && isFetching
  };
};
exports.useLoadRuleAggregationsQuery = useLoadRuleAggregationsQuery;