"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useGetFlappingSettings = void 0;
var _i18n = require("@kbn/i18n");
var _reactQuery = require("@tanstack/react-query");
var _kibana = require("../../common/lib/kibana");
var _get_flapping_settings = require("../lib/rule_api/get_flapping_settings");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useGetFlappingSettings = props => {
  const {
    enabled,
    onSuccess
  } = props;
  const {
    http,
    notifications: {
      toasts
    }
  } = (0, _kibana.useKibana)().services;
  const queryFn = () => {
    return (0, _get_flapping_settings.getFlappingSettings)({
      http
    });
  };
  const onErrorFn = () => {
    toasts.addDanger(_i18n.i18n.translate('xpack.triggersActionsUI.rulesSettings.modal.getRulesSettingsError', {
      defaultMessage: 'Failed to get rules Settings.'
    }));
  };
  const {
    data,
    isFetching,
    isError,
    isLoadingError,
    isLoading
  } = (0, _reactQuery.useQuery)({
    queryKey: ['getFlappingSettings'],
    queryFn,
    onError: onErrorFn,
    onSuccess,
    enabled,
    refetchOnWindowFocus: false,
    retry: false
  });
  return {
    isLoading: isLoading || isFetching,
    isError: isError || isLoadingError,
    data
  };
};
exports.useGetFlappingSettings = useGetFlappingSettings;