"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useColumns = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _authorization = require("../../../../lib/authorization");
var _reauthorization_utils = require("../../../../common/reauthorization_utils");
var _transform = require("../../../../../../common/types/transform");
var _constants = require("../../../../../../common/constants");
var _common = require("../../../../common");
var _use_actions = require("./use_actions");
var _managed_transforms_utils = require("../../../../common/managed_transforms_utils");
var _transform_health_colored_dot = require("./transform_health_colored_dot");
var _transform_task_state_badge = require("./transform_task_state_badge");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TRANSFORM_INSUFFICIENT_PERMISSIONS_MSG = _i18n.i18n.translate('xpack.transform.transformList.needsReauthorizationBadge.insufficientPermissions', {
  defaultMessage: 'This transform was created with insufficient permissions.'
});
const useColumns = (expandedRowItemIds, setExpandedRowItemIds, transformNodes, transformSelection) => {
  const {
    canStartStopTransform
  } = (0, _react.useContext)(_authorization.AuthorizationContext).capabilities;
  const {
    actions,
    modals
  } = (0, _use_actions.useActions)({
    forceDisable: transformSelection.length > 0,
    transformNodes
  });
  function toggleDetails(item) {
    const index = expandedRowItemIds.indexOf(item.config.id);
    if (index !== -1) {
      expandedRowItemIds.splice(index, 1);
      setExpandedRowItemIds([...expandedRowItemIds]);
    } else {
      expandedRowItemIds.push(item.config.id);
    }

    // spread to a new array otherwise the component wouldn't re-render
    setExpandedRowItemIds([...expandedRowItemIds]);
  }
  const columns = [{
    name: /*#__PURE__*/_react.default.createElement(_eui.EuiScreenReaderOnly, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.transform.transformList.showDetailsColumn.screenReaderDescription",
      defaultMessage: "This column contains clickable controls for showing more details on each transform"
    }))),
    align: _eui.RIGHT_ALIGNMENT,
    width: '40px',
    isExpander: true,
    render: item => /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      onClick: () => toggleDetails(item),
      "aria-label": expandedRowItemIds.includes(item.config.id) ? _i18n.i18n.translate('xpack.transform.transformList.rowCollapse', {
        defaultMessage: 'Hide details for {transformId}',
        values: {
          transformId: item.config.id
        }
      }) : _i18n.i18n.translate('xpack.transform.transformList.rowExpand', {
        defaultMessage: 'Show details for {transformId}',
        values: {
          transformId: item.config.id
        }
      }),
      iconType: expandedRowItemIds.includes(item.config.id) ? 'arrowDown' : 'arrowRight',
      "data-test-subj": "transformListRowDetailsToggle"
    })
  }, {
    field: _common.TRANSFORM_LIST_COLUMN.ID,
    'data-test-subj': 'transformListColumnId',
    name: 'ID',
    sortable: true,
    truncateText: true,
    scope: 'row',
    render: (transformId, item) => {
      if (!(0, _managed_transforms_utils.isManagedTransform)(item)) return transformId;
      return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, transformId, "\xA0", /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
        content: _i18n.i18n.translate('xpack.transform.transformList.managedBadgeTooltip', {
          defaultMessage: 'This transform is preconfigured and managed by Elastic; other parts of the product might have might have dependencies on its behavior.'
        })
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
        color: "hollow",
        "data-test-subj": "transformListRowIsManagedBadge"
      }, _i18n.i18n.translate('xpack.transform.transformList.managedBadgeLabel', {
        defaultMessage: 'Managed'
      }))));
    }
  }, {
    id: 'alertRule',
    name: /*#__PURE__*/_react.default.createElement(_eui.EuiScreenReaderOnly, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.transform.transformList.alertingRules.screenReaderDescription",
      defaultMessage: "This column displays an icon when there are alert rules associated with a transform"
    }))),
    width: '30px',
    render: item => {
      const needsReauth = (0, _reauthorization_utils.needsReauthorization)(item);
      const actionMsg = canStartStopTransform ? _i18n.i18n.translate('xpack.transform.transformList.needsReauthorizationBadge.reauthorizeTooltip', {
        defaultMessage: 'Reauthorize to start transforms.'
      }) : _i18n.i18n.translate('xpack.transform.transformList.needsReauthorizationBadge.contactAdminTooltip', {
        defaultMessage: 'Contact your administrator to request the required permissions.'
      });
      const needsReauthTooltipIcon = needsReauth ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
        content: `${TRANSFORM_INSUFFICIENT_PERMISSIONS_MSG} ${actionMsg}`
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        size: "s",
        color: "warning",
        type: 'alert'
      })), "\xA0") : null;
      const alertingRulesTooltipIcon = Array.isArray(item.alerting_rules) ? /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
        position: "bottom",
        content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.transform.transformList.alertingRules.tooltipContent",
          defaultMessage: "Transform has {rulesCount} associated alert {rulesCount, plural, one { rule} other { rules}}",
          values: {
            rulesCount: item.alerting_rules.length
          }
        })
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        type: "bell"
      })) : /*#__PURE__*/_react.default.createElement("span", null);
      return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, needsReauthTooltipIcon, alertingRulesTooltipIcon);
    }
  }, {
    field: _common.TRANSFORM_LIST_COLUMN.DESCRIPTION,
    'data-test-subj': 'transformListColumnDescription',
    name: _i18n.i18n.translate('xpack.transform.description', {
      defaultMessage: 'Description'
    }),
    sortable: true,
    truncateText: true
  }, {
    name: _i18n.i18n.translate('xpack.transform.type', {
      defaultMessage: 'Type'
    }),
    'data-test-subj': 'transformListColumnType',
    sortable: item => item.mode,
    truncateText: true,
    render(item) {
      let transformType = _i18n.i18n.translate('xpack.transform.type.unknown', {
        defaultMessage: 'unknown'
      });
      if ((0, _transform.isPivotTransform)(item.config) === true) {
        transformType = _i18n.i18n.translate('xpack.transform.type.pivot', {
          defaultMessage: 'pivot'
        });
      }
      if ((0, _transform.isLatestTransform)(item.config) === true) {
        transformType = _i18n.i18n.translate('xpack.transform.type.latest', {
          defaultMessage: 'latest'
        });
      }
      return /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
        color: "hollow"
      }, transformType);
    },
    width: '100px'
  }, {
    name: _i18n.i18n.translate('xpack.transform.status', {
      defaultMessage: 'Status'
    }),
    'data-test-subj': 'transformListColumnStatus',
    sortable: item => item.stats.state,
    truncateText: true,
    render(item) {
      return /*#__PURE__*/_react.default.createElement(_transform_task_state_badge.TransformTaskStateBadge, {
        state: item.stats.state,
        reason: item.stats.reason
      });
    },
    width: '100px'
  }, {
    name: _i18n.i18n.translate('xpack.transform.mode', {
      defaultMessage: 'Mode'
    }),
    'data-test-subj': 'transformListColumnMode',
    sortable: item => item.mode,
    truncateText: true,
    render(item) {
      const mode = item.mode;
      const color = 'hollow';
      return /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
        color: color
      }, mode);
    },
    width: '100px'
  }, {
    name: _i18n.i18n.translate('xpack.transform.progress', {
      defaultMessage: 'Progress'
    }),
    'data-test-subj': 'transformListColumnProgress',
    sortable: item => (0, _common.getTransformProgress)(item) || 0,
    truncateText: true,
    render(item) {
      const progress = (0, _common.getTransformProgress)(item);
      const isBatchTransform = typeof item.config.sync === 'undefined';
      if (progress === undefined && isBatchTransform === true) {
        return null;
      }
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        alignItems: "center",
        gutterSize: "xs"
      }, isBatchTransform && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        style: {
          width: '40px'
        },
        grow: false
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiProgress, {
        value: progress,
        max: 100,
        color: "primary",
        size: "m",
        "data-test-subj": "transformListProgress"
      }, progress, "%")), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        style: {
          width: '35px'
        },
        grow: false
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "xs"
      }, `${progress}%`))), !isBatchTransform && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        style: {
          width: '40px'
        },
        grow: false
      }, item.stats.state !== _constants.TRANSFORM_STATE.STOPPED && item.stats.state !== _constants.TRANSFORM_STATE.WAITING && item.stats.state !== _constants.TRANSFORM_STATE.FAILED && /*#__PURE__*/_react.default.createElement(_eui.EuiProgress, {
        color: "primary",
        size: "m"
      }), (item.stats.state === _constants.TRANSFORM_STATE.STOPPED || item.stats.state === _constants.TRANSFORM_STATE.WAITING || item.stats.state === _constants.TRANSFORM_STATE.FAILED) && /*#__PURE__*/_react.default.createElement(_eui.EuiProgress, {
        value: 0,
        max: 100,
        color: "primary",
        size: "m"
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        style: {
          width: '35px'
        },
        grow: false
      }, "\xA0")));
    },
    width: '100px'
  }, {
    name: _i18n.i18n.translate('xpack.transform.health', {
      defaultMessage: 'Health'
    }),
    'data-test-subj': 'transformListColumnHealth',
    sortable: item => item.stats.health.status,
    truncateText: true,
    render(item) {
      return /*#__PURE__*/_react.default.createElement(_transform_health_colored_dot.TransformHealthColoredDot, {
        healthStatus: item.stats.health.status
      });
    },
    width: '100px'
  }, {
    name: _i18n.i18n.translate('xpack.transform.tableActionLabel', {
      defaultMessage: 'Actions'
    }),
    actions: actions,
    width: '80px'
  }];
  return {
    columns,
    modals
  };
};
exports.useColumns = useColumns;