"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StatsBar = void 0;
var _react = _interopRequireDefault(require("react"));
var _stat = require("./stat");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const StatsBar = ({
  stats,
  dataTestSub
}) => {
  const statsList = Object.keys(stats).map(k => stats[k]);
  return /*#__PURE__*/_react.default.createElement("div", {
    className: "transformStatsBar",
    "data-test-subj": dataTestSub
  }, statsList.filter(s => s.show).map(s => /*#__PURE__*/_react.default.createElement(_stat.Stat, {
    key: s.label,
    stat: s
  })));
};
exports.StatsBar = StatsBar;