"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EditTransformFlyoutFormTextInput = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _use_edit_transform_flyout = require("./use_edit_transform_flyout");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function capitalizeFirstLetter(str) {
  return str.charAt(0).toUpperCase() + str.slice(1);
}
const EditTransformFlyoutFormTextInput = ({
  field,
  label,
  helpText,
  placeHolder = false
}) => {
  const {
    defaultValue,
    errorMessages,
    value
  } = (0, _use_edit_transform_flyout.useEditTransformFlyout)(field);
  const {
    formField
  } = (0, _use_edit_transform_flyout.useEditTransformFlyout)('actions');
  const upperCaseField = capitalizeFirstLetter(field);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: label,
    helpText: helpText,
    isInvalid: errorMessages.length > 0,
    error: errorMessages
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    "data-test-subj": `transformEditFlyout${upperCaseField}Input`,
    placeholder: placeHolder ? _i18n.i18n.translate('xpack.transform.transformList.editFlyoutFormPlaceholderText', {
      defaultMessage: 'Default: {defaultValue}',
      values: {
        defaultValue
      }
    }) : undefined,
    isInvalid: errorMessages.length > 0,
    value: value,
    onChange: e => formField({
      field,
      value: e.target.value
    }),
    "aria-label": label
  }));
};
exports.EditTransformFlyoutFormTextInput = EditTransformFlyoutFormTextInput;