"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useScheduleNowAction = void 0;
var _react = _interopRequireWildcard(require("react"));
var _constants = require("../../../../../../common/constants");
var _authorization = require("../../../../lib/authorization");
var _hooks = require("../../../../hooks");
var _schedule_now_action_name = require("./schedule_now_action_name");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useScheduleNowAction = (forceDisable, transformNodes) => {
  const {
    canScheduleNowTransform
  } = (0, _react.useContext)(_authorization.AuthorizationContext).capabilities;
  const scheduleNowTransforms = (0, _hooks.useScheduleNowTransforms)();
  const action = (0, _react.useMemo)(() => ({
    name: item => /*#__PURE__*/_react.default.createElement(_schedule_now_action_name.ScheduleNowActionName, {
      items: [item],
      forceDisable: forceDisable,
      transformNodes: transformNodes
    }),
    available: item => item.stats.state === _constants.TRANSFORM_STATE.STARTED,
    enabled: item => !(0, _schedule_now_action_name.isScheduleNowActionDisabled)([item], canScheduleNowTransform, transformNodes),
    description: _schedule_now_action_name.scheduleNowActionNameText,
    icon: 'play',
    type: 'icon',
    onClick: item => scheduleNowTransforms([{
      id: item.id
    }]),
    'data-test-subj': 'transformActionScheduleNow'
  }), [canScheduleNowTransform, forceDisable, scheduleNowTransforms, transformNodes]);
  return {
    action,
    scheduleNowTransforms
  };
};
exports.useScheduleNowAction = useScheduleNowAction;