"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WithPrivileges = exports.PrivilegesWrapper = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _components = require("../../../components");
var _authorization_provider = require("./authorization_provider");
var _not_authorized_section = require("./not_authorized_section");
var _has_privilege_factory = require("../../../../../common/privilege/has_privilege_factory");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const WithPrivileges = ({
  privileges: requiredPrivileges,
  children
}) => {
  const {
    isLoading,
    privileges
  } = (0, _react.useContext)(_authorization_provider.AuthorizationContext);
  const privilegesToArray = (0, _has_privilege_factory.toArray)(requiredPrivileges).map(p => {
    const [section, privilege] = p.split('.');
    if (!privilege) {
      // Oh! we forgot to use the dot "." notation.
      throw new Error('Required privilege must have the format "section.privilege"');
    }
    return [section, privilege];
  });
  const hasPrivilege = (0, _has_privilege_factory.hasPrivilegeFactory)(privileges);
  const hasPrivileges = isLoading ? false : privilegesToArray.every(hasPrivilege);
  const privilegesMissing = privilegesToArray.reduce((acc, [section, privilege]) => {
    if (privilege === '*') {
      acc[section] = privileges.missingPrivileges[section] || [];
    } else if (privileges.missingPrivileges[section] && privileges.missingPrivileges[section].includes(privilege)) {
      const missing = acc[section] || [];
      acc[section] = [...missing, privilege];
    }
    return acc;
  }, {});
  return children({
    isLoading,
    hasPrivileges,
    privilegesMissing
  });
};
exports.WithPrivileges = WithPrivileges;
const MissingClusterPrivileges = ({
  missingPrivileges,
  privilegesCount
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  justifyContent: "spaceAround"
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react.default.createElement(_eui.EuiPageContent_Deprecated, {
  verticalPosition: "center",
  horizontalPosition: "center",
  color: "danger"
}, /*#__PURE__*/_react.default.createElement(_not_authorized_section.NotAuthorizedSection, {
  title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.transform.app.deniedPrivilegeTitle",
    defaultMessage: "You're missing cluster privileges"
  }),
  message: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.transform.app.deniedPrivilegeDescription",
    defaultMessage: "To use this section of Transforms, you must have {privilegesCount, plural, one {this cluster privilege} other {these cluster privileges}}: {missingPrivileges}.",
    values: {
      missingPrivileges,
      privilegesCount
    }
  })
}))));
const PrivilegesWrapper = ({
  children,
  privileges
}) => /*#__PURE__*/_react.default.createElement(WithPrivileges, {
  privileges: privileges
}, ({
  isLoading,
  hasPrivileges,
  privilegesMissing
}) => {
  if (isLoading) {
    return /*#__PURE__*/_react.default.createElement(_components.SectionLoading, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.transform.app.checkingPrivilegesDescription",
      defaultMessage: "Checking privileges\u2026"
    }));
  }
  if (!hasPrivileges) {
    return /*#__PURE__*/_react.default.createElement(MissingClusterPrivileges, {
      missingPrivileges: privilegesMissing.cluster.join(', '),
      privilegesCount: privilegesMissing.cluster.length
    });
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, children);
});
exports.PrivilegesWrapper = PrivilegesWrapper;